part of web;

class NoteController extends GetxController {
  final BookDetailModel bookDetailModel;
  // 当前的章节id
  final String chapterId;
  NoteController({required this.bookDetailModel,required this.chapterId});
  List<NoteModel> notes = [];

  final EasyRefreshController refreshController = EasyRefreshController(
    controlFinishLoad: true,
    controlFinishRefresh: true,
  );

  late TextEditingController searchInput = TextEditingController();

  final int _limit = 10;
  int _page = 1;
  bool _noMore = false;

  // 是否展示搜索结果
  bool showSearch = false;

  final int _searchLimit = 10;
  int _searchPage = 1;
  bool _searchNoMore = false;

  // 搜全文
  List<SearchAllModel> searchALlResults = [];


  @override
  void onReady() {
    onRefresh();
    super.onReady();
  }

  @override
  void onClose() {
    refreshController.dispose();
    searchInput.dispose();
    super.onClose();
  }

  void setShowSearch(bool show){
    showSearch = show;
    update();
  }

  /// 搜全文
  Future<void> searchAll([bool isRefresh = false]) async {
    if (isRefresh) _searchPage = 1;
    // 网路请求
    final result = await LibraryAPI.searchAll(
        page: _searchPage,
        limit: _searchLimit,
        bookId: bookDetailModel.bookId.toString(),
        key: searchInput.text
    );
    Console.log('--------------------------------');
    // 如果是刷新 清理数据
    if (isRefresh) searchALlResults.clear();
    searchALlResults.addAll(result);
    _searchPage ++;
    _searchNoMore = result.length < _searchLimit;
    update();

  }

  void onRefreshSearch() async {
    try {
      await searchAll(true);
      refreshController.finishRefresh(IndicatorResult.success);
      refreshController.resetFooter();
    } catch (error) {
      Console.log('--error-----------------------------$error-');
      refreshController.finishRefresh(IndicatorResult.fail);
    }
  }

  void onLoadingSearch() async {
    if (_searchNoMore) {
      refreshController.finishLoad(IndicatorResult.noMore);
      return;
    }
    try {
      await searchAll();
      refreshController.finishLoad();
    } catch (error) {
      refreshController.finishLoad(IndicatorResult.fail);
    }
  }

  /// 获取笔记列表
  Future<void> _getNotes([bool isRefresh = false]) async {
    if (isRefresh) _page = 1;
    // 网路请求
    final result = await LibraryAPI.noteList(
        page: _page,
        limit: _limit,
        bookId: bookDetailModel.bookId.toString(),
        chapterId: chapterId
    );

    for(NoteModel noteModel in result){
      if(noteModel.noteContent!=null && noteModel.noteContent!.audio != null){
        if(noteModel.noteContent!.audio!.isNotEmpty){
          for(MediaModel? mediaModel in noteModel.noteContent!.audio!){
            Duration? duration = await just_audio.AudioPlayer().setUrl(mediaModel?.content??'');

            mediaModel?.duration = Tools.formatDuration(duration!);
          }
        }
      }
    }
    // 如果是刷新 清理数据
    if (isRefresh) notes.clear();
    notes.addAll(result);
    _page ++;
    _noMore = result.length < _limit;
    update();

  }

  void onRefresh() async {
    try {
      await _getNotes(true);
      refreshController.finishRefresh(IndicatorResult.success);
      refreshController.resetFooter();
    } catch (error) {
      refreshController.finishRefresh(IndicatorResult.fail);
      Console.log('error-----------------------$error');
    }
  }

  void onLoading() async {
    if (_noMore) {
      refreshController.finishLoad(IndicatorResult.noMore);
      return;
    }
    try {
      await _getNotes();
      refreshController.finishLoad();
    } catch (error) {
      Console.log('error-----------------------$error');
      refreshController.finishLoad(IndicatorResult.fail);
    }
  }

}