part of user_coin;

class UserCoinPage extends StatefulWidget {
  const UserCoinPage({Key? key}) : super(key: key);

  @override
  State<UserCoinPage> createState() => _UserCoinPageState();
}

class _UserCoinPageState extends State<UserCoinPage> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<UserCoinController>(
      init: UserCoinController(),
      builder: (controller) => Scaffold(
        appBar: CustomAppBar(
          title: const Text('紫荆币'),
          actions: [
            GestureDetector(
              onTap: (){
                showModalBottomSheet(
                  context: context,
                  shape: RoundedRectangleBorder(
                    borderRadius: BorderRadius.vertical(top: Radius.circular(8.w)),
                  ),
                  builder: (BuildContext context) {
                    return CoinRechargePage();
                  },
                ).then((value) {
                  print('================================================================');
                  // Navigator.of(context).removeRoute(ModalRoute.of(context)!);
                });
              },
                child: Text('充值',style: TextStyle(color: Colours.c3,fontSize: 14.w,height: 1.5,fontWeight: Fonts.medium),)
            )
          ],
        ),
        body: CustomPullScrollView(
          controller: controller.refreshController,
          onRefresh: controller.onRefresh,
          onLoading: controller.onLoading,
          child: Container(
            margin: EdgeInsets.all(10.w),
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(8.w),
              color: Colors.white,
              boxShadow: [
                BoxShadow(
                  color: const Color(0xFFC7C7C7).withOpacity(0.5),
                  offset: Offset(3.w, 0),
                  blurRadius: 10.w,
                  spreadRadius: 0.w,
                ),
              ],
            ),
            child: ListView.builder(
              itemBuilder: (BuildContext context, int index){
                return BuildCell(model: controller.coins[index],);
              },
              itemCount: controller.coins.length,
            ),
          ),
        ),
      ),
    );
  }
}
