part of about;

class AboutPage extends StatefulWidget {
  const AboutPage({Key? key}) : super(key: key);

  @override
  State<AboutPage> createState() => _AboutPageState();
}

class _AboutPageState extends State<AboutPage> {
  PackageInfo packageInfo = PackageInfo(
    appName: 'Unknown',
    packageName: 'Unknown',
    version: 'Unknown',
    buildNumber: 'Unknown',
    buildSignature: 'Unknown',
    installerStore: 'Unknown',
  );

  @override
  void initState() {
    _getVersion();
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: const Text('关于我们'),
      ),
      body: Column(
        mainAxisAlignment: MainAxisAlignment.spaceBetween,

        // crossAxisAlignment: CrossAxisAlignment.center,
        children: [
          Column(
            children: [
              Container(
                margin: EdgeInsets.only(top: 55.w),
                height: 60.w,
                width: 60.w,
                // color: Colors.cyan,
                child: const CustomImage.asset(url: 'assets/images/icon.png'),
              ),
              Gaps.vGaps15,
              Text('紫荆数智学堂',style: TextStyle(fontSize: 17.w,fontWeight: Fonts.medium,color: Colours.c3),),
              Gaps.vGaps5,
              Text('V${packageInfo.version??''}',style: TextStyle(fontSize: 13.w,color: Colours.c9)),
            ],
          ),
          SafeArea(
            child: Column(
              children: [
                Row(
                  mainAxisAlignment: MainAxisAlignment.center,
                  children: [
                    GestureDetector(
                      child: Text('《用户协议》',textAlign: TextAlign.right,style: TextStyle(fontSize: 10.w,color: Color(0xFF2A82D9)),),
                      onTap: (){
                        context.pushNamed(Routes.terms,queryParameters: {'url':'$kServerUrl$kUserAgreement'});
                      },
                    ),
                    Gaps.vGaps15,
                    Container(width: 1.w,height: 10.w,color: const Color(0xFFC8C8C8),),
                    Gaps.vGaps15,
                    GestureDetector(
                      child: Text('《隐私协议》',textAlign: TextAlign.left,style: TextStyle(fontSize: 10.w,color: Color(0xFF2A82D9))),
                      onTap:(){
                        context.pushNamed(Routes.terms,queryParameters: {'url':'$kServerUrl$kUserPriAgreement'});
                      } ,
                    )
                  ],
                ),
                Gaps.hGaps10,
                Text('Copyright © 2024 Zijing Education. All rights reserved.\n清控紫荆（北京）教育科技股份有限公司京\nICP证150431号',style: TextStyle(color: Colours.c9,fontSize:9.w),textAlign: TextAlign.center,),
                Gaps.vGaps25,
              ],
            ),
          )

        ],
      ),
    );
  }

  void _getVersion() async {
    final info = await PackageInfo.fromPlatform();
     setState(() {
       packageInfo = info;
     });
  }
}
