part of web;

class ReadDiscussPage extends StatefulWidget {
  // 点 x 事件
  final void Function()? onTap;
  // 点击 搜索全文 中的列表事件
  final void Function(SearchAllModel sModel)? onTapSearchItem;
  final BookDetailModel bookDetailModel;
  // 当前的章节id
  final String chapterId;
  const ReadDiscussPage({
    Key? key,
    required this.onTap,
    required this.bookDetailModel,
    required this.chapterId,
    this.onTapSearchItem
  }) : super(key: key);

  @override
  State<ReadDiscussPage> createState() => _ReadDiscussPageState();
}

class _ReadDiscussPageState extends State<ReadDiscussPage> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<DiscussController>(
      init: DiscussController(bookDetailModel: widget.bookDetailModel,chapterId: widget.chapterId),
      builder:(controller) => Scaffold(
        resizeToAvoidBottomInset: false,
        body: Column(
          crossAxisAlignment: CrossAxisAlignment.end,
          children: [
            GestureDetector(
              onTap: (){
                widget.onTap!();
              },
              child: Container(
                  // color: Colors.red,
                  padding: EdgeInsets.only(left: 15.w,right: 15.w,top: 15.w,bottom: 15.w),
                  child: Image.asset('assets/images/close.png')
              ),
            ),
            Row(
              children: [
                Expanded(
                    child: Container(
                      margin: EdgeInsets.only(left: 15.w,right: 15.w,),
                      decoration: BoxDecoration(
                        color: const Color(0xFFF9F9F9),
                        borderRadius: BorderRadius.circular(17.5.w),
                        boxShadow: [
                          BoxShadow(
                            color: const Color(0xFFC7C7C7).withOpacity(0.5),
                            offset: Offset(3.w, 0),
                            blurRadius: 10.w,
                            spreadRadius: 0.w,
                          ),
                        ],
                      ),
                      child: ClipRRect(
                        borderRadius: BorderRadius.circular(17.5.w),
                        child: CustomInputSearch(
                          controller: controller.searchInput,
                          readOnly: false,
                          hintText: '搜索全文',
                          onTap: () {
                            // context.pushNamed(Routes.msgs);
                          },
                          onEditingComplete: () {
                            controller.setShowSearch(true);
                            controller.onRefreshSearch();
                            Tools.unfocus();
                          },
                        ),
                      ),
                    ),
                ),
                controller.showSearch?GestureDetector(
                  onTap: () {
                    controller.setShowSearch(false);
                    Tools.unfocus();
                  },
                  child:  Container(
                    margin: EdgeInsets.only(right: 15.w),
                    child: Text('取消'),
                  )
                ):const SizedBox(),
              ],
            ),
            controller.showSearch? Expanded(
                child: BuildSearchAll(
                  onTap: (SearchAllModel sModel){
                    if (widget.onTapSearchItem !=null) {
                      widget.onTapSearchItem!(sModel);
                    }
                  },
                  searchALlResults: controller.searchALlResults,
                )):
            controller.showSearch?const SizedBox():BuildBook(bookDetailModel: widget.bookDetailModel,),
            controller.showSearch?const SizedBox():Expanded(
              child: Stack(
                children: [
                  ListView.builder(
                    itemBuilder: (BuildContext context,int index){
                      DiscussModel model = controller.discuss[index];
                      return BuildDiscuss(
                        model: model,
                        controller: controller,
                        bookId: widget.bookDetailModel.bookId.toString(),
                      );
                    },
                    itemCount: controller.discuss.length,
                  ),
                  Visibility(
                    visible: controller.showReply,
                      child: Positioned(
                        bottom: MediaQuery.of(context).viewInsets.bottom -69 ,
                        left: 0,
                        right: 0,
                        child: Container(
                          color: Colors.white,
                          child: Padding(
                            padding: const EdgeInsets.all(8.0),
                            child: Row(
                              children: [
                                Expanded(
                                  child:  TextField(
                                    autofocus: true,
                                    maxLines: null,
                                    controller: controller.replyInput,
                                    decoration: InputDecoration(
                                      border: InputBorder.none,
                                      enabledBorder: InputBorder.none,
                                      focusedBorder: InputBorder.none,
                                      hintText: '请输入内容',
                                      hintStyle:TextStyle(fontSize: 12.w,height: 1.5,color: Colours.c9,),
                                      filled: true,
                                      fillColor: Colours.cF8,
                                    ),
                                  ),
                                ),
                                Gaps.hGaps10,
                                GestureDetector(
                                  onTap: (){
                                    controller.submit();
                                    controller.setShow();
                                  },
                                  child: Container(
                                    decoration: BoxDecoration(
                                      borderRadius: BorderRadius.circular(15.w),
                                      color: AppTheme.primary,
                                      gradient: LinearGradient(
                                        colors: [const Color(0xFFD53676).withOpacity(0.9),AppTheme.primary] , // 不可点击时的颜色，透明度为0.7
                                        begin: Alignment.topCenter,
                                        end: Alignment.bottomCenter,
                                      ),
                                    ),
                                    padding:  EdgeInsets.symmetric(horizontal:13.5.w,vertical: 4.w),
                                    child:  Text('发表',style: TextStyle(fontSize: 14.w,fontWeight: Fonts.medium,color: Colors.white),),
                                  ),
                                )
                              ],
                            ),
                          ),
                        ),
                      ),
                  )
                ],
              )
            )

          ],
        ),
      ),
    );
  }
}
