part of user_love;

class UserLovePage extends StatefulWidget {
  const UserLovePage({Key? key}) : super(key: key);

  @override
  State<UserLovePage> createState() => _UserLovePageState();
}

class _UserLovePageState extends State<UserLovePage> {
  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: () async {
        context.pop(true);
        return false;
      },
      child: GetBuilder<UserLoveController>(
        init: UserLoveController(),
        builder:(controller) => Scaffold(
          appBar: AppBar(
            centerTitle: true,
            title: const Text('我的收藏'),
          ),
          body: Container(
            color: Colours.cF9,
            child: CustomPullScrollView(
              controller: controller.refreshController,
              onRefresh: controller.onRefresh,
              onLoading: controller.onLoading,
              child: ListView.builder(
                itemBuilder: (BuildContext context, int index){
                  CourseModel model = controller.loves[index];
                  return BuildItem(model: model,onTap: (){
                    controller.unLoved(bookId: model.bookId.toString());
                  },);
                },
                itemCount: controller.loves.length,
              ),
            ),
          ),
        ),
      ),
    );
  }
}
