part of user_edit_note;

class UserEditNotePage extends StatefulWidget {
  const UserEditNotePage({Key? key}) : super(key: key);

  @override
  State<UserEditNotePage> createState() => _UserEditNotePageState();
}

class _UserEditNotePageState extends State<UserEditNotePage> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<UserEditNoteController>(
      init: UserEditNoteController(),
      builder:(controller)=> Scaffold(
        appBar: AppBar(
          title: const Text('笔记编辑'),
          centerTitle: true,
        ),
        body: Container(
            color: Colors.white,
            margin: EdgeInsets.symmetric(horizontal: 15.w),
            child: Column(
              children: [
                ClipRRect(
                  borderRadius: BorderRadius.circular(4.w),
                  child: Container(
                    color: Colours.cF8,
                    constraints: BoxConstraints(
                        minHeight: 100.w
                    ),
                    child: Column(
                      children: [
                        TextField(
                          // focusNode: widget.controller.discussContentFocusNode,
                          // maxLines: null,
                          // autofocus: widget.controller.chatType ==0?false:true,
                          // controller: widget.controller.contentInput,
                          decoration: InputDecoration(
                            border: InputBorder.none,
                            enabledBorder: InputBorder.none,
                            focusedBorder: InputBorder.none,
                            hintText: '请输入内容',
                            hintStyle:TextStyle(fontSize: 12.w,height: 1.5,color: Colours.c9,),
                            filled: true,
                            fillColor: Colours.cF8,
                          ),
                        ),
                        Column(
                          children: [
                            GridView.builder(
                              // padding: const EdgeInsets.only(left: 13,top: 10),
                              physics: const NeverScrollableScrollPhysics(),
                              shrinkWrap: true,
                              gridDelegate: SliverGridDelegateWithFixedCrossAxisCount(
                                  crossAxisCount: 6,
                                  crossAxisSpacing: 2.w,
                                  mainAxisSpacing: 2.w,
                                  childAspectRatio: 1
                              ),
                              itemBuilder: (BuildContext context, int index) {
                                return Stack(
                                  children: [
                                    Positioned(
                                        left:0,
                                        right: 0,
                                        top:0,
                                        bottom: 0,
                                        child: Container()
                                    ),
                                    Positioned(
                                        right: 5.w,
                                        top: 5.w,
                                        child: GestureDetector(
                                            onTap: (){
                                            },
                                            child: Image.asset('assets/images/del_close.png',width: 12.w,height: 12.w,)
                                        )
                                    )
                                  ],
                                );
                              },
                              itemCount: 3,
                            ),
                            Container(
                              color: Colors.red,
                              child: MediaQuery.removePadding(
                                context: context,
                                removeTop: true,
                                child: ListView.builder(
                                  physics: const NeverScrollableScrollPhysics(),
                                  shrinkWrap: true,
                                  itemBuilder: (BuildContext context, int index){
                                    return Container(
                                      height: 20.w,
                                      margin: EdgeInsets.only(right: 130.w),
                                      child: Container(
                                        margin: EdgeInsets.only(top: 5.w),
                                        padding: EdgeInsets.only(right:20.w,left: 10.w),
                                        decoration: BoxDecoration(
                                          borderRadius: BorderRadius.circular(10.w),
                                          color: Colours.cF9,
                                        ),
                                        child: Row(
                                          // mainAxisSize: MainAxisSize.min,
                                          mainAxisAlignment:MainAxisAlignment.spaceBetween,
                                          children: [
                                            Image.asset('assets/images/audio.png'),
                                            Text('0:00/1:52',style: TextStyle(fontSize: 10.w,height: 1.4,color: Colours.c9),)
                                          ],
                                        ),
                                      ),
                                    );
                                  },
                                  itemCount: 3,
                                ),
                              ),
                            )
                          ],
                        )
                      ],
                    ),
                  ),
                ),
                Container(
                  padding: EdgeInsets.symmetric(vertical: 10.w),
                  child: Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    crossAxisAlignment: CrossAxisAlignment.center,
                    children: [
                      Row(
                        children: [
                          GestureDetector(
                              // onTap: () async{
                              //   final assets = await AssetsPicker.image(
                              //     context: context,
                              //   );
                              //   widget.controller.addDiscussInputImages(assets!.path);
                              // },
                              child: Image.asset('assets/images/read_add_img.png')),
                          Gaps.hGaps10,
                          GestureDetector(
                              onTap: () async {
                                // if(widget.controller.startRecording){
                                //   widget.controller.stopRecorder();
                                // }
                                // else {
                                //   widget.controller.record();
                                //
                                // }
                              },
                              child: Image.asset(controller.startRecording?'assets/images/stop.png':'assets/images/read_add_audio.png')
                          ),
                          GestureDetector(
                            onTap: (){
                              controller.setIsPublic();
                            },
                            child: Row(
                              crossAxisAlignment: CrossAxisAlignment.center,
                              children: [
                                Gaps.hGaps10,
                                Image.asset(controller.isPublic?'assets/images/pay_check.png':'assets/images/pay_uncheck.png'),
                                SizedBox(width: 3.w,),
                                Text('公开',style: TextStyle(fontSize: 13.w,height: 1.3,color: Colours.c9),)
                              ],
                            ),
                          )
                        ],
                      ),
                      GestureDetector(
                        onTap: (){
                          controller.submit();
                        },
                        child: Container(
                          decoration: BoxDecoration(
                            borderRadius: BorderRadius.circular(15.w),
                            color: AppTheme.primary,
                            gradient: LinearGradient(
                              colors: [const Color(0xFFD53676).withOpacity(0.9),AppTheme.primary] , // 不可点击时的颜色，透明度为0.7
                              begin: Alignment.topCenter,
                              end: Alignment.bottomCenter,
                            ),
                          ),
                          padding:  EdgeInsets.symmetric(horizontal:13.5.w,vertical: 4.w),
                          child:  Text('发表',style: TextStyle(fontSize: 14.w,fontWeight: Fonts.medium,color: Colors.white),),
                        ),
                      )
                    ],
                  ),
                )
              ],
            )
        ),
      ),
    );
  }
}
