part of user_notes_des;

class UserNotesDesController extends GetxController {
  final String tag;
  final CourseModel model;
  UserNotesDesController(this.tag,this.model);
  List<NoteModel> notes = [];

  final EasyRefreshController refreshController = EasyRefreshController(
    controlFinishLoad: true,
    controlFinishRefresh: true,
  );

  final int _limit = 10;
  int _page = 1;
  bool _noMore = false;


  @override
  void onReady() {
    onRefresh();
    super.onReady();
  }

  @override
  void onClose() {
    refreshController.dispose();
    super.onClose();
  }

  void delNotes({required String notesId,required String bookId}) async {
    final result = await MineAPI.delNotes(notesId: notesId, bookId: bookId);
    if (result){
      onRefresh();
    }
  }

  /// 获取笔记列表
  Future<void> _getNotes([bool isRefresh = false]) async {
    if (isRefresh) _page = 1;
    // 网路请求
    final result = await MineAPI.noteList(
        page: _page,
        limit: _limit,
        bookId: model.bookId.toString(),
        types: tag
    );
    for(NoteModel noteModel in result){
      if(noteModel.noteContent!.audio!.isNotEmpty){
        for(MediaModel mediaModel in noteModel.noteContent!.audio!){
          Duration? duration = await just_audio.AudioPlayer().setUrl(mediaModel.content??'');

          mediaModel.duration = Tools.formatDuration(duration!);
        }
      }
    }
    // 如果是刷新 清理数据
    if (isRefresh) notes.clear();
    notes.addAll(result);
    _page ++;
    _noMore = result.length < _limit;
    update();

  }

  void onRefresh() async {
    try {
      await _getNotes(true);
      refreshController.finishRefresh(IndicatorResult.success);
      refreshController.resetFooter();
    } catch (error) {
      Console.log('----error--------------------------------------$error--------------');
      refreshController.finishRefresh(IndicatorResult.fail);
    }
  }

  void onLoading() async {
    if (_noMore) {
      refreshController.finishLoad(IndicatorResult.noMore);
      return;
    }
    try {
      await _getNotes();
      refreshController.finishLoad();
    } catch (error) {
      refreshController.finishLoad(IndicatorResult.fail);
    }
  }



}