part of utils;


abstract class Tools {
  static void unfocus() {
    WidgetsBinding.instance.focusManager.primaryFocus?.unfocus();
  }

  static String dateFromMS(
      int timestamp, {
        String pattern = 'yyyy-MM-dd',
        bool humanize = false,
      }) {
    final dateTime = DateTime.fromMillisecondsSinceEpoch(timestamp*1000);
    if (humanize) {
      final now = DateTime.now();
      final difference = now.difference(dateTime);
      if (difference.inMinutes < 60) {
        if (difference.inMinutes < 1) return '刚刚';
        return '${difference.inMinutes}分钟前';
      } else if (difference.inHours < 24) {
        return '${difference.inHours}小时前';
      } else if (difference.inDays < 30) {
        return '${difference.inDays}天前';
      } else if (now.year == dateTime.year) {
        return DateFormat('MM-dd').format(dateTime);
      }
    }
    return DateFormat(pattern).format(dateTime);
  }

  static String formatDuration(Duration duration) {
    String twoDigits(int n) => n.toString().padLeft(2, '0');
    String twoDigitMinutes = twoDigits(duration.inMinutes.remainder(60));
    String twoDigitSeconds = twoDigits(duration.inSeconds.remainder(60));
    return "${duration.inHours}:$twoDigitMinutes:$twoDigitSeconds";
  }
}




