part of book_pay;

class BuildItem extends StatelessWidget {
  final CourseModel model;
  const BuildItem({
    super.key,
    required this.model,
  });

  @override
  Widget build(BuildContext context) {
    return Container(
        decoration: BoxDecoration(
            borderRadius:BorderRadius.circular(5.w),
            color: Colors.white,
            boxShadow: [
              BoxShadow(
                color: const Color(0xFFC7C7C7).withOpacity(0.5),
                spreadRadius: 2.w,
                blurRadius: 5.w,
                offset: Offset(3.w, 0), // changes the position of the shadow
              ),
            ]
        ),
        margin: EdgeInsets.only(left: 10.w,right: 10.w,top: 10.w),
        height: 110,
        child: Row(
          children: [
            ///左侧
            Container(
              margin: EdgeInsets.only(left: 12.w,right: 11.w),
              child: Row(
                children: [
                  CustomCard(
                    width: 72.w,
                    height: 86.w,
                    url: model.img??'',
                  )
                ],
              ),
            ),
            ///右侧
            Expanded(
              child: Container(
                padding: EdgeInsets.only(top: 12.w,bottom: 10.w),
                child: Column(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Text(model.bookName??'',style: TextStyle(fontSize: 13.w,fontWeight: Fonts.medium,color: Colours.c3),maxLines: 2,overflow: TextOverflow.ellipsis,),
                        SizedBox(height: 5.w,),
                        Text(model.authors??'',style: TextStyle(fontSize: 11.w,color: Colours.c9)),
                      ],
                    ),
                    Text('￥${model.vipPrice??''}',style: TextStyle(fontSize: 14.w,fontWeight: FontWeight.w500,color: AppTheme.primary)),
                  ],
                ),
              ),
            )
          ],
        )
    );
  }
}
