part of course;

class CoursePage extends StatefulWidget {
  const CoursePage({Key? key}) : super(key: key);

  @override
  State<CoursePage> createState() => _CoursePageState();
}

class _CoursePageState extends State<CoursePage> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<CourseController>(
      init: CourseController(),
      builder: (controller) =>Scaffold(
          appBar: CustomAppBar(
            titleSpacing: 0,
            title:  Padding(
              padding: EdgeInsets.symmetric(horizontal: AppTheme.margin),
              child: CustomInputSearch(
                readOnly:true,
                hintText: '请输入书籍名称',
                onTap: () {
                  context.pushNamed(Routes.search);
                }
              ),
            ),
            actions: [
              CustomButton.icon(
                padding: EdgeInsets.zero,
                backgroundColor: Colors.transparent,
                icon: Image.asset(
                  'assets/images/read_history.png',
                ),
                onPressed: () async {
                  context.pushNamed(Routes.studyHistory);
                },
              ),
              GestureDetector(
                onTap: () async{
                  final  result =  await context.pushNamed(Routes.msgs);
                  if (result == true) {
                    controller.getNums();
                  }
                },
                child: badges.Badge(
                  position: badges.BadgePosition.topEnd(top: -5.w, end: 0),
                  showBadge: controller.num == 0?false:true,
                  badgeContent: Text(controller.num.toString(),style: TextStyle(fontSize: 7.w,color: Colors.white),),
                  badgeStyle: const badges.BadgeStyle(
                    badgeColor: AppTheme.primary,
                    shape: badges.BadgeShape.circle
                  ),
                  child: CustomButton.icon(
                      padding: EdgeInsets.zero,
                      backgroundColor: Colors.transparent,
                      icon: Image.asset(
                        'assets/images/msg_black.png',
                      ),
                      // onPressed: () => context.pushNamed(Routes.msgs),
                    ),
                ),
              )
            ],
          ),
          body:Container(
            color: const Color(0xFFF9F9F9),
            child: Column(
              children: [
                controller.ads.isNotEmpty?
                Container(
                  color: Colors.transparent,
                  padding: EdgeInsets.symmetric(horizontal: 10.w),
                  child: BuildBanner(
                    items:controller.ads,
                    onTap:(adModel){
                      context.pushNamed(Routes.adDetail,extra: adModel);
                    } ,
                  ),
                ):const SizedBox(),
                Expanded(
                  child: CustomPullScrollView(
                    controller: controller.refreshController,
                    onRefresh: controller.onRefresh,
                    onLoading: controller.onLoading,
                    child: GridView.builder(
                        padding: EdgeInsets.only(left: 13.w,top: 10.w),
                        gridDelegate: SliverGridDelegateWithFixedCrossAxisCount(
                            crossAxisCount: 2,
                          crossAxisSpacing: 0,
                          mainAxisSpacing: 10.w,
                          childAspectRatio: 0.85
                        ),
                        itemBuilder: (BuildContext context, int index) {
                          CourseModel model = controller.courses[index];
                          return GestureDetector(
                            child: Book(
                              model: model,
                              onTapContinue: () async{
                                BookDetailModel bookDetails = await controller.getBookDetails(model.bookId.toString());
                                if(context.mounted){
                                  final result = await context.pushNamed(Routes.web,queryParameters: {'book_id': bookDetails.bookId.toString(),'chapter_id': bookDetails.chapterId.toString(),'chapter_name':bookDetails.chapterName.toString()},extra:bookDetails);
                                  if (result == true){
                                    controller.getNums();
                                  }
                                }
                              },
                            ),
                            onTap: (){
                                context.pushNamed(Routes.bookDetail,queryParameters: {'book_id':model.bookId.toString()});

                            },
                          );
                        },
                       itemCount: controller.courses.length,
                    ),
                  ),
                ),
              ],
            ),
          )
    ));
  }
}


