part of book_detail;

class BuildBook extends StatelessWidget {
  final BookDetailModel model;
  const BuildBook({
    Key? key,
    required this.model
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
        decoration: const BoxDecoration(
            // color: Colors.red,
            gradient: LinearGradient(
              colors: [Color(0xFFF7F5F5),Color(0xFFFFFFFF)],
              begin: Alignment.topCenter,
              end: Alignment.bottomCenter,
            ),
        ),
        // margin: const EdgeInsets.only(left: 10,right: 10,top: 10),
        height: 125,
        child: Row(
          children: [
            ///左侧
            Container(
              margin: const EdgeInsets.only(left: 15,right: 15),
              child: Row(
                children: [
                  CustomCard(
                    url: model.img??'',
                  )
                ],
              ),
            ),
            ///右侧
            Expanded(
              child: Container(
                // color: Colors.cyan,
                padding: const EdgeInsets.only(top: 12,bottom: 15),
                child: Column(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Text(model.bookName??'',style: const TextStyle(fontSize: 16,fontWeight: Fonts.medium,color: Colours.c3),maxLines: 1,overflow: TextOverflow.ellipsis,),
                        const SizedBox(height: 5,),
                        Text(model.authors??'',style: const TextStyle(fontSize: 13,fontWeight: FontWeight.w400,color: Colours.c6)),
                      ],
                    ),
                    Row(
                      children: [
                        Text('￥${model.vipPrice}',style: const TextStyle(fontSize: 14,fontWeight: FontWeight.w500,color: AppTheme.primary)),
                        Gaps.hGaps10,
                        Text('￥${model.price}',style: const TextStyle(
                            fontSize: 12,color: Colours.c9,
                            decoration: TextDecoration.lineThrough,
                            decorationColor: Colours.c9, // 可选，指定删除线的颜色
                            decorationThickness: 1
                        )),
                      ],
                    )
                  ],
                ),
              ),
            )
          ],
        )
    );
  }
}
