part of book_pay;

class BuildItem extends StatelessWidget {
  final CourseModel model;
  const BuildItem({
    super.key,
    required this.model,
  });

  @override
  Widget build(BuildContext context) {
    return Container(
        decoration: BoxDecoration(
            borderRadius:BorderRadius.circular(5),
            color: Colors.white,
            boxShadow: [
              BoxShadow(
                color: const Color(0xFFC7C7C7).withOpacity(0.5),
                spreadRadius: 2,
                blurRadius: 5,
                offset: const Offset(3, 0), // changes the position of the shadow
              ),
            ]
        ),
        margin: const EdgeInsets.only(left: 10,right: 10,top: 10),
        height: 110,
        child: Row(
          children: [
            ///左侧
            Container(
              margin: const EdgeInsets.only(left: 12,right: 11),
              child: Row(
                children: [
                  CustomCard(
                    width: 72,
                    height: 86,
                    url: model.img??'',
                  )
                ],
              ),
            ),
            ///右侧
            Expanded(
              child: Container(
                padding: const EdgeInsets.only(top: 12,bottom: 10),
                child: Column(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Text(model.bookName??'',style: const TextStyle(fontSize: 13,fontWeight: Fonts.medium,color: Colours.c3),maxLines: 2,overflow: TextOverflow.ellipsis,),
                        const SizedBox(height: 5,),
                        Text(model.authors??'',style: const TextStyle(fontSize: 11,color: Colours.c9)),
                      ],
                    ),
                    Text('￥${model.vipPrice??''}',style: const TextStyle(fontSize: 14,fontWeight: FontWeight.w500,color: AppTheme.primary)),
                  ],
                ),
              ),
            )
          ],
        )
    );
  }
}
