part of study_history;

class BuildDayItem extends StatelessWidget {
  final StudyHistoryModel historyModel;
  const BuildDayItem({
    Key? key,
    required this.historyModel
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: const EdgeInsets.only(left: 10,top: 10,right: 10),
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(8),
        boxShadow:  [
          BoxShadow(
            color: Colours.cC7.withOpacity(0.5),
            offset: const Offset(1, 3),
            blurRadius: 10,
            spreadRadius: 0,
          ),
        ],
        color: Colors.white
      ),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Container(
            margin: const EdgeInsets.only(left: 10),
            decoration: const BoxDecoration(
              borderRadius: BorderRadius.only(
                topLeft: Radius.circular(8.0),
                topRight: Radius.circular(8.0),
              ),
              // color: Colors.cyan,
            ),
            height: 32,
            alignment: Alignment.centerLeft,
            child: Text(historyModel.time??'',style: const TextStyle(fontSize: 13,height: 1.4,color: Colours.c6),),
          ),
          ListView.builder(
            shrinkWrap: true,
            physics: const NeverScrollableScrollPhysics(),
            itemBuilder:(BuildContext context, int index){
              return _buildItem(historyModel.courses[index]);
            },
            itemCount: historyModel.courses.length,
          )
        ],
      ),
    );
  }

  Widget _buildItem(CourseModel courseModel){
    return Container(
      margin: const EdgeInsets.only(left: 10,right: 10),
      child: Column(
        children: [
          Container(
            color: Colours.cF0,
            height: 0.5,
          ),
          Container(
            margin: const EdgeInsets.only(top: 11.5,bottom: 14.5),
            // color: Colors.yellow,
            child: Row(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                CustomCard(
                  width: 72,
                  height: 86,
                  url: courseModel.img??'',
                ),
                Expanded(
                  child: Container(
                    // color: Colors.green,
                    padding: const EdgeInsets.only(top: 2.5,left: 13),
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      // mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      children: [
                        Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            Text(courseModel.bookName??'',style: const TextStyle(fontSize: 14,height: 1.5,fontWeight: Fonts.medium,color: Colours.c3),maxLines: 1,overflow: TextOverflow.ellipsis,),
                            Gaps.vGaps5,
                            Text(courseModel.authors??'',style: const TextStyle(fontSize: 12,height: 1.4,color: Colours.c6),),
                          ],
                        ),
                        Gaps.vGaps25,
                        Row(
                          mainAxisAlignment: MainAxisAlignment.spaceBetween,
                          children: [
                            Container(
                              color: AppTheme.primary.withOpacity(0.1),
                              padding: const EdgeInsets.symmetric(horizontal: 3.5),
                              child: Text(courseModel.typeName,style: const TextStyle(fontSize: 11,height: 1.3,color:AppTheme.primary),),
                            ),
                            // Spacer(),
                            Text('上次读到：${courseModel.lastChapter}',style: const TextStyle(fontSize: 11,height: 1.3,color: Colours.c6),)
                          ],
                        )
                      ],
                    ),
                  ),
                )
              ],
            ),
          )
        ],
      ),
    );
  }
}
