part of user_info;

class UserInfoPage extends StatefulWidget {
  final UserInfoModel userInfo;

  const UserInfoPage({Key? key, required this.userInfo}) : super(key: key);

  @override
  State<UserInfoPage> createState() => _UserInfoPageState();
}

class _UserInfoPageState extends State<UserInfoPage> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<UserInfoController>(
      init: UserInfoController(widget.userInfo),
      builder: (controller) =>
          Scaffold(
            appBar: AppBar(
              title: const Text('个人信息'),
              centerTitle: true,
            ),
            body: Container(
              margin: const EdgeInsets.symmetric(
                  horizontal: AppTheme.margin, vertical: AppTheme.margin),
              decoration: BoxDecoration(
                borderRadius: BorderRadius.circular(8),
                color: Colors.white,
                boxShadow: [
                  BoxShadow(
                    color: const Color(0xFFC7C7C7).withOpacity(0.5),
                    offset: const Offset(3, 0),
                    blurRadius: 10.w,
                    spreadRadius: 0.w,
                  ),
                ],
              ),
              child: ClipRRect(
                  borderRadius: BorderRadius.circular(8),
                  child: Column(
                    mainAxisSize: MainAxisSize.min,
                    children: [

                    /// 头像
                    Container(
                    height: 52,
                    padding: const EdgeInsets.only(left: 18, right: 15),
                    child: GestureDetector(
                      onTap: () async {
                        final assets = await AssetsPicker.image(
                          context: context,
                          source: ImageSource.gallery,
                          maxWidth: 512,
                          maxHeight: 512,
                        );
                        controller.upload(path: assets!.path);
                      },
                      child: Container(
                        color: Colors.transparent,
                        child: Row(
                          mainAxisAlignment: MainAxisAlignment.spaceBetween,
                          children: [
                            const Text(
                              '头像',
                              style: TextStyle(
                                  color: Colours.c3,
                                  fontSize: 14,
                                  height: 1.6),
                            ),
                            Row(
                              children: [
                                Container(
                                  width: 33.w,
                                  height: 33.w,
                                  decoration: const BoxDecoration(
                                    shape: BoxShape.circle,
                                    color: Colors.cyan,
                                  ),
                                  child: CustomImage.network(
                                    url: controller.userInfo.headImg ?? '',
                                    radius: 16.5,
                                  ),
                                ),
                                Gaps.hGaps10,
                                SizedBox(
                                  width: 5,
                                  height: 8,
                                  child: Image.asset(
                                      'assets/images/right_arrow.png'),
                                )
                              ],
                            )
                          ],
                        ),
                      ),
                    ),
                  ),
                  Container(
                    color: Colours.cLine,
                    margin: const EdgeInsets.symmetric(horizontal: 15),
                    height: 1,
                  ),
                  GestureDetector(
                      onTap: () {
                        context.pushNamed(Routes.nike, extra: controller.userInfo);
                      },
                      child: _buildItem(
                        '昵称',
                        widget.userInfo.name ?? '',
                      )),
                  Container(
                    color: Colours.cLine,
                    margin: const EdgeInsets.symmetric(horizontal: 15),
                    height: 1,
                  ),
                  GestureDetector(
                    onTap: () {
                      context.pushNamed(
                          Routes.gender, extra: controller.userInfo);
                    },
                    child: _buildItem(
                        '性别',
                      getGender(widget.userInfo.sex)
                    // widget.userInfo.sex == 1 ? '男' : '女',
                  )),
              ],
            ),
          ),
    )),);
  }

  getGender(num? sex) {
    String gender;
    if (sex == 1) {
      gender = "男";
    } else if (sex == 2) {
      gender = "女";
    } else {
      gender = "保密";
    }
    return gender;
  }

  Widget _buildItem(String title, String value) {
    return Container(
      padding: const EdgeInsets.only(left: 18, right: 15),
      color: Colors.transparent,
      height: 52,
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceBetween,
        crossAxisAlignment: CrossAxisAlignment.center,
        children: [
          Text(
            title,
            style: const TextStyle(
              fontSize: 14,
              color: Colours.c3,
            ),
          ),
          Row(
            children: [
              Text(
                value,
                style: const TextStyle(
                  fontSize: 14,
                  color: Colours.c9,
                ),
              ),
              Gaps.hGaps10,
              SizedBox(
                width: 5,
                height: 8,
                child: Image.asset('assets/images/right_arrow.png'),
              )
            ],
          )
        ],
      ),
    );
  }
}
