part of user_notes_des;

class BuildNote extends StatelessWidget {
  final NoteModel model;
  const BuildNote({
    Key? key,
    required this.model
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: const EdgeInsets.only(left: 10,right: 10,top: 10),
      padding: const EdgeInsets.all(10),
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(4),
        color: Colors.white,
        boxShadow: [
          BoxShadow(
            color: const Color(0xFFC7C7C7).withOpacity(0.5),
            offset: const Offset(1.5, 0),
            blurRadius: 7.w,
            spreadRadius: 0.w,
          ),
        ],
      ),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Text('看来谁都不记得自己为何出现在此',style: TextStyle(
            fontSize: 14,
            height: 1.5,
            color: Colors.red,

          ),),
          Gaps.vGaps13,
          _buildImageGridView(),
          Gaps.vGaps13,
          _buildAudioGridView(),
          Gaps.vGaps13,
          Container(
            width: double.infinity,
            padding: const EdgeInsets.symmetric(vertical: 5,horizontal: 10),
            color: Colours.cF8,
            child:Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Text(model.chapterName??'',style: const TextStyle(fontSize: 12,height: 1.5,color: Colours.c9),),
                Text('内容：${model.content??''}',style: const TextStyle(fontSize: 12,height: 1.5,color: Colours.c9),),
              ],
            )
          )
        ],
      ),
    );
  }

  // 图片
  Widget _buildImageGridView(){
    return GridView.builder(
      // padding: const EdgeInsets.only(left: 13,top: 10),
      physics: NeverScrollableScrollPhysics(),
      shrinkWrap: true,
      gridDelegate: const SliverGridDelegateWithFixedCrossAxisCount(
          crossAxisCount: 6,
          crossAxisSpacing: 2,
          mainAxisSpacing: 2,
          childAspectRatio: 1
      ),
      itemBuilder: (BuildContext context, int index) {
        return Container(
          color: Colors.red,
          child: Center(child: Text('图片')),
        );
      },
      itemCount: 3,
    );
  }

  Widget _buildAudioGridView(){
    return GridView.builder(
      // padding: const EdgeInsets.only(left: 13,top: 10),
      physics: NeverScrollableScrollPhysics(),
      shrinkWrap: true,
      gridDelegate: const SliverGridDelegateWithFixedCrossAxisCount(
          crossAxisCount: 6,
          crossAxisSpacing: 2,
          mainAxisSpacing: 2,
          childAspectRatio: 1
      ),
      itemBuilder: (BuildContext context, int index) {
        return Container(
          color: Colors.red,
          child: Center(child: Text('音频')),
        );
      },
      itemCount: 3,
    );
  }

}
