part of forget_pwd;


class ForgetPwdPage extends StatefulWidget {
  const ForgetPwdPage({Key? key}) : super(key: key);

  @override
  State<ForgetPwdPage> createState() => _ForgetPwdPageState();
}

class _ForgetPwdPageState extends State<ForgetPwdPage> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<ForgetPwdController>(
      init: ForgetPwdController(),
      builder: (controller) =>Scaffold(
        appBar: AppBar(
          centerTitle: true,
          title: const Text('忘记密码'),
        ),
        body: Container(
          margin: const EdgeInsets.only(left: 10, right: 10,top: 15),
          child: Column(
            children: [
              CustomFormInput(
                // label: 'Phone',
                // required: true,
                hintText: '请输入手机号',
                keyboardType: TextInputType.number,
                controller: controller.phoneInput,
                onChanged: (text){
                  controller.setCanClick();
                },
              ),
              Gaps.vGaps10,
              Stack(
                alignment: Alignment.centerRight,
                children: [
                  CustomFormInput(
                    // label: 'Phone',
                    // required: true,
                    hintText: '请输入验证码',
                    keyboardType: TextInputType.number,
                    controller: controller.codeInput,
                    onChanged: (text){
                      controller.setCanClick();
                    },
                  ),
                  Positioned(
                      right: 10,
                      child: Row(
                        children: [
                          Container(height: 20,width: 1,color: const Color(0xFFEBEBEB),),
                          Gaps.hGaps10,
                          GestureDetector(
                            child: Container(
                                padding: const EdgeInsets.symmetric(vertical: 10),
                                color: Colors.yellow,
                                child: Text(controller.isCounting?'${controller.countDown}':'获取验证码',style: const TextStyle(fontSize: 11,color: AppTheme.primary,height: 1.4),)),
                            onTap: (){
                              if (controller.isCounting == false){
                                controller.sendCode();
                              }
                            },
                          ),
                        ],
                      )
                  ),
                ],
              ),
              Gaps.vGaps40,
              CustomGradientButton(
                text: '下一步',
                isEnabled: controller.enable,
                onPressed: () {
                  context.pushNamed(Routes.resetPwd,queryParameters: {'phone': controller.phoneInput.text,'code': controller.codeInput.text});
                },
              )
            ],
          ),
        ),
      ),
    );
  }
}
