part of apis;

abstract class AccountAPI {

  /// 1、登录
  ///
  static Future <UserModel> login({
    required String phone,
    required String type,
    String? password,
    String? code,
    String? uuid,
  }) async {
    // assert((password != null && code == null) ||
    //     (password == null && code != null),
    // 'Provide either a password or a verification code, not both.');

    Map<String,dynamic> params = {
      'phone' : phone,
      'type' : type,
    };

    // 密码登录
    if(type == '1'){
      params['password'] = password;
    }
    // 验证码登录
    if(type == '2'){
      params['code'] = code;
      params['uuid'] = uuid;
    }
    final result = await HttpService.to.post(
      '/v1/members/login/login',
      excludeToken: true,
      showLoading: true,
      params: params
    );
    print(result.data);
    if (result.data is! Map) return UserModel();
    return UserModel.fromJson(result.data);
  }

  /// 2、退出登录
  ///
  static Future logout() async{
    final result = await HttpService.to.post(
      '/v1/members/login/logout',
      params: {}
    );
    if (result.data is Map && result.data['is_success'] == 1){
      return true;
    }
    return false;
  }

  /// 3、注销
  ///
  static Future delete() async{
    final result = await HttpService.to.post(
      '/v1/members/login/del',
      params: {}
    );
    if (result.data is Map && result.data['is_success'] == 1){
      return true;
    }
    return false;
  }

  /// 4、发送验证码
  ///
  static Future sendCode({
    required String phone,
    required String type,
  }) async {

    String uuid = '';
    final DeviceInfoPlugin device = DeviceInfoPlugin();
    if(Platform.isIOS){
      final IosDeviceInfo iosInfo = await device.iosInfo;
      uuid = iosInfo.identifierForVendor??'';
    }
    else if(Platform.isAndroid){
      const androidIdPlugin = AndroidId();
      uuid = await androidIdPlugin.getId()??'';
    }

    final result = await HttpService.to.post(
      '/v1/members/login/sendCode',
      params: {
        'phone': phone,
        'types': type,
        'uuid':uuid
      },
      excludeToken: true,
      showLoading: true,
    );
    if (result.data is Map && result.data['is_success'] == 1){
      return true;
    }
    return false;
  }

  /// 5、重置密码
  ///
  static Future resetPassword({
    required String phone,
    required String code,
    required String password,
    required String rePassword,
  }) async {
    final result = await HttpService.to.post(
      '/v1/members/login/editPassword',
      params: {
        'phone': phone,
        'code': code,
        'password': password,
        'repassword': rePassword
      },
      excludeToken: true,
      showLoading: true,
    );
    if (result.data is Map && result.data['is_success'] == 1){
      return true;
    }
    return false;
  }

  /// 6、验证验证码
  static Future checkCode({
    required String phone,
    required String code,
  }) async {
    final result = await HttpService.to.post(
      '/v1/members/login/checkPhoneCode',
      params: {
        'phone': phone,
        'code': code
      },
      excludeToken: true,
      showLoading: true,
    );
    if (result.data is Map && result.data['is_success'] == 1){
      return true;
    }
    return false;
  }





}