part of change_pwd;

class ChangePwdController extends GetxController {
  // 用户信息模型
  final UserInfoModel userInfo;

  ChangePwdController(this.userInfo);
  // 新密码
  final TextEditingController pwdInput = TextEditingController();
  // 确认密码
  final TextEditingController pwd2Input = TextEditingController();
  // 显示密码
  final ValueNotifier<bool> showPassword = ValueNotifier(false);
  // 显示密码
  final ValueNotifier<bool> showPassword2 = ValueNotifier(false);
  // 按钮是否可用
  bool _enable = false;
  bool get enable => _enable;

  void onShowPassword() => showPassword.value = !showPassword.value;

  void onShowPassword2() => showPassword2.value = !showPassword2.value;

  /// 是否可点击
  void setCanClick() {
    if (ValidatorTool.isValidPassword(pwdInput.text) &&
        ValidatorTool.isValidPassword(pwd2Input.text) &&
        (pwdInput.text == pwd2Input.text)) {
      Console.log('-------${pwdInput.text}-------------${pwd2Input.text}');
      _enable = true;
    } else {
      _enable = false;
    }
    update();
  }

  @override
  void onClose() {
    pwd2Input.dispose();
    pwdInput.dispose();
    super.onClose();
  }

  /// 更改密码
  Future<bool> changePwd() async {
    final result = await MineAPI.changePwd(
        password: EncryptUtil.encodeMd5(EncryptUtil.encodeMd5(pwdInput.text)),
        rePassword:
            EncryptUtil.encodeMd5(EncryptUtil.encodeMd5(pwd2Input.text)));
    if (result) {
      userInfo.password =
          EncryptUtil.encodeMd5(EncryptUtil.encodeMd5(pwdInput.text));
      update();
    }
    return result;
  }

// void resetPassword(BuildContext context) async {
//   final result = await AccountAPI.resetPassword(
//     phone: phone,
//     code: code,
//     password: pwdInput.text,
//     rePassword: pwd2Input.text
//   );
//   if (result){
//     if (context.mounted){
//       context.goNamed(Routes.login);
//     }
//   }
//   else{
//
//   }
// }
}
