part of search;

class SearchController extends GetxController {
  final EasyRefreshController refreshController = EasyRefreshController(
    controlFinishLoad: true,
    controlFinishRefresh: true,
  );
  late TextEditingController searchController = TextEditingController();
  bool showHistory = true;
  // 搜索记录数组
  List<String> records = [];
  // 书籍数组
  List<CourseModel> books = [];
  // 每页数量
  final int _limit = 20;
  // 当前页码
  int _page = 1;
  // 是否有更多
  bool _noMore = false;

  @override
  void onReady() {
    _getSearchRecords();
    super.onReady();
  }

  @override
  void onClose() {
    searchController.dispose();
    super.onClose();
  }

  /// 获取搜索记录
  void _getSearchRecords() async {
    records = await CommonAPI.searchRecords();
    update();
  }

  /// 清除搜索记录
  void clear() async {
    bool result = await CommonAPI.clear();
    if (result) {
      _getSearchRecords();
    }
  }

  /// 搜索书籍
  void search() async {
    books = await CommonAPI.searchBooks(keyWord: searchController.text);
    _getSearchRecords();
    update();
  }

  /// 收藏 与 取消收藏
  void love({required String bookId, required num isCollection}) async {
    if (isCollection == 0) {
      isCollection = 1;
    } else {
      isCollection = 0;
    }
    bool result =
        await CommonAPI.love(bookId: bookId, love: isCollection.toString());
    if (result) {
      onRefresh();
    }
  }

  /// 获取图书列表数据
  Future<void> _getBooks([bool isRefresh = false]) async {
    if (isRefresh) _page = 1;
    // 网路请求
    final result =
        await LibraryAPI.books(page: _page, limit: _limit, categoryId: '');
    // 如果是刷新 清理数据
    if (isRefresh) books.clear();
    books.addAll(result);
    _page++;
    _noMore = result.length < _limit;
    update();
  }

  /// 刷新数据
  void onRefresh() async {
    try {
      await _getBooks(true);
      refreshController.finishRefresh(IndicatorResult.success);
      refreshController.resetFooter();
    } catch (error) {
      refreshController.finishRefresh(IndicatorResult.fail);
    }
  }

  ///  本地搜索历史
/*
  ///获取搜索关键字数据
  List<String> _getHistory(){
    List <String>historys = [];
    historys.addAll(StorageService.to.getList(kSearchHistory));
    ///过滤空字符串
    historys.remove('');
    return historys;
  }

  ///存储搜索关键字
  void saveHistory(){
    Tools.unfocus();
    var history = searchController.text;
    ///过滤空字符串
    if(history.isEmpty){
      return;
    }
    List <String>historys = [];
    historys.addAll(StorageService.to.getList(kSearchHistory));
    historys.remove('');


    if(historys.contains(history)){
      historys.remove(history);
      historys.insert(0, history);
    }
    else{
      if (historys.length >= _maxStorageNum){
        historys.remove(historys.last);
        historys.insert(0, history);
      }
      else{
        historys.insert(0, history);
      }
    }
    StorageService.to.setList(kSearchHistory, historys);

    searchList = _getHistory();
    update();
  }

  ///清除搜索关键字
  void clearHistory(){
    StorageService.to.setList(kSearchHistory, []);
    searchList = _getHistory();
    update();
  }

  */
}
