
/*

import 'dart:async';
import 'dart:io';

import 'package:flutter/gestures.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:fluwx/fluwx.dart';
import 'package:in_app_purchase/in_app_purchase.dart';
import 'package:tobias/tobias.dart' as tobias;
import 'package:flutter_easyloading/flutter_easyloading.dart';

import 'package:ace_word/utils/http.dart';
import 'package:ace_word/utils/global_data.dart' as globals;
import 'package:ace_word/pages/browser.dart';
import 'package:ace_word/components/ace/navibar/index.dart';
import 'package:tobias/tobias.dart';

class Vip extends StatefulWidget {
  const Vip({Key? key}) : super(key: key);

  @override
  State<Vip> createState() => _VipState();
}

/// 去除ListView的顶部阴影
class MyBehavior extends ScrollBehavior {
  @override
  Widget buildViewportChrome(BuildContext context, Widget child, AxisDirection axisDirection) {
    return child;
  }
}

class _VipState extends State<Vip> {
  int chosenIndex = 3;
  Map settings = {};
  List payInfoList = [];
  String orderNo = '';
  String payMethod = 'wechat-pay';
  String? userID;

  var inAppPurchaseInstance = InAppPurchase.instance;
  late StreamSubscription<List<PurchaseDetails>> _subscription;

  /// 初始化事件
  Future<void> init() async {
    // setData: userID & settings
    settings = await HTTP(url: '/settings').request();
    userID = await HTTP(url: '/user/id').request();
    setState(() {
      settings = settings;
      userID = userID;
    });
    // print(settings);
    // print(userID);

    // setData: userID & settings
    payInfoList = await HTTP(url: '/pay/info').request();
    setState(() {
      payInfoList = payInfoList;
    });
    print(payInfoList);

    final Stream<List<PurchaseDetails>> purchaseUpdated = inAppPurchaseInstance.purchaseStream;
    _subscription = purchaseUpdated.listen((purchaseDetailsList) {
      _listenToPurchaseUpdated(purchaseDetailsList);
    }, onDone: () {
      _subscription.cancel();
    }, onError: (error) {
      // handle error here.
    });

    // 监听微信支付回调
    weChatResponseEventHandler.listen((event) async {
      // 支付成功
      if (event.errCode == 0) {
        try {
          var res = await HTTP(url: '/pay/status').request();
          EasyLoading.showSuccess('支付成功');
          globals.needRefreshMinePage = true;
          setState(() {
            settings['vipExpireDate'] = res['expireDate'];
          });
        } catch (err) {
          var errMap = err as Map;
          if (errMap['errcode'] == 419) {
            EasyLoading.showError('支付未完成');
          }
        }
      } else {
        if (event.errCode == -2) {
          EasyLoading.showError('取消支付');
        }
      }
    });
  }

  // 要把localVerificationData发到服务端，验证
  Future<bool> _verifyPurchase(PurchaseDetails purchaseDetails) async {
    try {
      var result = await HTTP(url: '/pay/ios/notify', method: 'POST', data: {
        'orderNo': orderNo,
        'receipt': purchaseDetails.verificationData.serverVerificationData,
      }).request();
      return result['errcode'] == 0;
    } catch (e) {
      return false;
    }
  }

// iOS支付监听
  Future<void> _listenToPurchaseUpdated(List<PurchaseDetails> purchaseDetailsList) async {
    for (var purchaseDetails in purchaseDetailsList) {
      // 支付进行中
      if (purchaseDetails.status == PurchaseStatus.pending) {
        // _showPendingUI();
      } else {
        if (purchaseDetails.status == PurchaseStatus.error) {
          EasyLoading.showError('发生错误，请重试');
        } else if (purchaseDetails.status == PurchaseStatus.canceled) {
          EasyLoading.showError('支付取消');
        } else if (purchaseDetails.status == PurchaseStatus.restored) {
        } else if (purchaseDetails.status == PurchaseStatus.purchased) {
          inAppPurchaseInstance.completePurchase(purchaseDetails);
          // 1. 用户购买成功，苹果服务器向用户手机发送令牌以后
          // tips: 如果关机，信号差...需要本地持久化这个令牌，每次启动，检查本地是否有该令牌，如果有，向服务器发送开通会员请求，删掉
          // 2. 用户拿着令牌，向我们自己服务器发送，并开通会员
          bool valid = await _verifyPurchase(purchaseDetails);
          if (valid) {
            try {
              Future.delayed(const Duration(milliseconds: 500));
              var res = await HTTP(url: '/pay/status').request();
              EasyLoading.showSuccess('支付成功');
              globals.needRefreshMinePage = true;
              setState(() {
                settings['vipExpireDate'] = res['expireDate'];
              });
            } catch (err) {
              var errMap = err as Map;
              if (errMap['errcode'] == 419) {
                EasyLoading.showError('支付未完成');
              }
            }
          } else {
            EasyLoading.showError('发生错误，请联系客服');
            // _handleInvalidPurchase(purchaseDetails);
          }
        }
        if (purchaseDetails.pendingCompletePurchase) {
          await InAppPurchase.instance.completePurchase(purchaseDetails);
        }
      }
    }
  }

  @override
  void initState() {
    super.initState();
    init();
  }

  String _formatCreateDate(createDate) {
    return createDate == null ? '' : createDate.substring(0, 4) + '.' + createDate.substring(4, 6) + '.' + createDate.substring(6);
  }

  @override
  Widget build(BuildContext context) {
    if (Theme.of(context).platform == TargetPlatform.android) {
      SystemUiOverlayStyle style = const SystemUiOverlayStyle(statusBarColor: Colors.transparent, statusBarIconBrightness: Brightness.light);
      SystemChrome.setSystemUIOverlayStyle(style);
    }

    return ScrollConfiguration(
      behavior: MyBehavior(),
      child: Scaffold(
        body: Stack(children: [
          Container(
            decoration: const BoxDecoration(
              color: Color(0xFF161A27),
            ),
          ),
          Container(
            width: double.infinity,
            height: double.infinity,
            margin: const EdgeInsets.only(top: 54),
            decoration: const BoxDecoration(
              color: Color(0xFF161A27),
            ),
          ),
          Column(
            children: [
              SizedBox(height: MediaQuery.of(context).padding.top + 54 + 16),
              Expanded(
                child: Stack(children: [
                  Container(
                    padding: const EdgeInsets.symmetric(horizontal: 16),
                    child: Image.asset(
                      'images/vip/background.png',
                      width: MediaQuery.of(context).size.width - 32,
                      height: (MediaQuery.of(context).size.width - 32) * 162 / 343,
                    ),
                  ),
                  Positioned(
                    top: 46,
                    left: 16 + 16,
                    child: Row(
                      children: [
                        Container(
                          padding: const EdgeInsets.all(1), // Border width
                          decoration: BoxDecoration(color: Colors.white, borderRadius: BorderRadius.circular(100)),
                          child: ClipRRect(
                            borderRadius: BorderRadius.circular(100),
                            child: SizedBox.fromSize(
                              size: const Size.fromRadius(26), // Image radius
                              child: globals.settings['avatarUrl'] == null
                                  ? const CircleAvatar(
                                      radius: 1000,
                                      backgroundColor: Colors.white,
                                      backgroundImage: AssetImage('images/icons/avatar.png'),
                                    )
                                  : Image.asset(
                                      'images/vip/avatar.png',
                                    ),
                            ),
                          ),
                        ),
                        const SizedBox(width: 12),
                        Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            Text(
                              '${(settings['nickName'] == null || (userID == null)) ? '...' : settings['nickName'].isEmpty ? '词友_${userID!.substring(0, 6)}' : settings['nickName']}',
                              style: const TextStyle(
                                fontSize: 18,
                                fontWeight: FontWeight.w600,
                                color: Color(0xFF72522D),
                              ),
                            ),
                            const SizedBox(height: 2),
                            Text(
                              settings['vipExpireDate'] == '00000000' || int.parse(globals.settings['vipExpireDate']) < int.parse(globals.todayDate)
                                  ? '尚未开通会员'
                                  : '有效期至${_formatCreateDate(settings['vipExpireDate'])}',
                              style: const TextStyle(
                                fontSize: 12,
                                color: Color(0xFFB58A5A),
                              ),
                            ),
                          ],
                        ),
                      ],
                    ),
                  ),
                  Positioned(
                    top: 120,
                    child: Container(
                        width: MediaQuery.of(context).size.width,
                        height: MediaQuery.of(context).size.height - (MediaQuery.of(context).padding.top + 54 + 16 + 120),
                        padding: const EdgeInsets.symmetric(horizontal: 16),
                        decoration: const BoxDecoration(
                          color: Color(0xFFFFFFFF),
                          borderRadius: BorderRadius.only(topLeft: Radius.circular(16.0), topRight: Radius.circular(16.0)),
                        ),
                        child: ListView(
                          padding: const EdgeInsets.only(top: 24),
                          children: [
                            Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                const Text(
                                  '解锁会员',
                                  style: TextStyle(
                                    fontSize: 18,
                                    fontWeight: FontWeight.w600,
                                    color: Color(0xFF1D2129),
                                  ),
                                ),
                                const SizedBox(height: 20),
                                SizedBox(
                                  width: MediaQuery.of(context).size.width - 32,
                                  height: 92,
                                  child: Row(
                                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                    children: [
                                      GestureDetector(
                                        onTap: () {
                                          setState(() {
                                            chosenIndex = 3;
                                          });
                                        },
                                        child: Container(
                                          width: MediaQuery.of(context).size.width - 32,
                                          height: 92,
                                          decoration: BoxDecoration(
                                            color: chosenIndex == 3 ? const Color(0xFFFEF9E9) : const Color(0xFFFFFFFF),
                                            border: Border.all(
                                              color: chosenIndex == 3 ? const Color(0xFFAC884E) : const Color(0xFFE2E2E2),
                                              width: 1.0,
                                            ),
                                            borderRadius: const BorderRadius.all(Radius.circular(14.0)),
                                          ),
                                          child: Stack(children: [
                                            if (chosenIndex == 3)
                                              Positioned(
                                                top: 0,
                                                right: 0,
                                                child: Image.asset(
                                                  'images/vip/check.png',
                                                  width: 24,
                                                  height: 20,
                                                ),
                                              ),
                                            SizedBox(
                                              height: 92,
                                              child: Row(mainAxisAlignment: MainAxisAlignment.spaceBetween, crossAxisAlignment: CrossAxisAlignment.center, children: [
                                                Padding(
                                                  padding: const EdgeInsets.only(left: 16.0),
                                                  child: Column(
                                                    mainAxisAlignment: MainAxisAlignment.center,
                                                    crossAxisAlignment: CrossAxisAlignment.start,
                                                    children: const [
                                                      Text(
                                                        '终身会员',
                                                        style: TextStyle(
                                                          fontSize: 16,
                                                          fontWeight: FontWeight.w600,
                                                          color: Color(0xFF434346),
                                                        ),
                                                      ),
                                                      SizedBox(height: 4),
                                                      Text(
                                                        '您将永久解锁本软件的所有会员权益',
                                                        style: TextStyle(
                                                          fontSize: 11,
                                                          color: Color(0xFF86909C),
                                                        ),
                                                      ),
                                                    ],
                                                  ),
                                                ),
                                                Padding(
                                                  padding: const EdgeInsets.only(right: 16.0),
                                                  child: Column(
                                                    mainAxisAlignment: MainAxisAlignment.center,
                                                    children: [
                                                      Row(
                                                        mainAxisAlignment: MainAxisAlignment.center,
                                                        children: [
                                                          Image.asset(
                                                            'images/vip/rmb.png',
                                                            width: 16,
                                                            height: 14,
                                                          ),
                                                          Text(
                                                            '${payInfoList.isEmpty ? '...' : payInfoList[3]['money'] ~/ 100}',
                                                            style: const TextStyle(
                                                              fontFamily: 'SFProDisplay',
                                                              fontSize: 28,
                                                              fontWeight: FontWeight.w700,
                                                              color: Color(0xFFBB8247),
                                                            ),
                                                          ),
                                                          const SizedBox(width: 4),
                                                        ],
                                                      ),
                                                      const Text(
                                                        '￥168',
                                                        style: TextStyle(
                                                          fontSize: 12,
                                                          color: Color(0xFF939495),
                                                          decoration: TextDecoration.lineThrough,
                                                        ),
                                                      ),
                                                    ],
                                                  ),
                                                ),
                                              ]),
                                            ),
                                          ]),
                                        ),
                                      ),
                                    ],
                                  ),
                                ),
                                const SizedBox(height: 16),
                                SizedBox(
                                  width: MediaQuery.of(context).size.width - 32,
                                  height: 138,
                                  child: Row(
                                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                    children: [
                                      GestureDetector(
                                        onTap: () {
                                          setState(() {
                                            chosenIndex = 0;
                                          });
                                        },
                                        child: Container(
                                          width: (MediaQuery.of(context).size.width - 32 - 30) / 3,
                                          decoration: BoxDecoration(
                                            color: chosenIndex == 0 ? const Color(0xFFFEF9E9) : const Color(0xFFFFFFFF),
                                            border: Border.all(
                                              color: chosenIndex == 0 ? const Color(0xFFAC884E) : const Color(0xFFE2E2E2),
                                              width: 1.0,
                                            ),
                                            borderRadius: const BorderRadius.all(Radius.circular(14.0) //                 <--- border radius here
                                                ),
                                          ),
                                          child: Stack(children: [
                                            if (chosenIndex == 0)
                                              Positioned(
                                                top: 0,
                                                right: 0,
                                                child: Image.asset(
                                                  'images/vip/check.png',
                                                  width: 24,
                                                  height: 20,
                                                ),
                                              ),
                                            Positioned(
                                              top: 20,
                                              child: SizedBox(
                                                width: (MediaQuery.of(context).size.width - 32 - 30) / 3,
                                                child: Column(children: [
                                                  const Text(
                                                    '12个月',
                                                    style: TextStyle(
                                                      fontSize: 14,
                                                      fontWeight: FontWeight.w600,
                                                      color: Color(0xFF434346),
                                                    ),
                                                  ),
                                                  const SizedBox(height: 6),
                                                  Row(
                                                    mainAxisAlignment: MainAxisAlignment.center,
                                                    children: [
                                                      Image.asset(
                                                        'images/vip/rmb.png',
                                                        width: 16,
                                                        height: 14,
                                                      ),
                                                      Text(
                                                        '${payInfoList.isEmpty ? '...' : payInfoList[0]['money'] ~/ 100}',
                                                        style: const TextStyle(
                                                          fontFamily: 'SFProDisplay',
                                                          fontSize: 28,
                                                          fontWeight: FontWeight.w700,
                                                          color: Color(0xFFBB8247),
                                                        ),
                                                      ),
                                                      const SizedBox(width: 4),
                                                    ],
                                                  ),
                                                  const SizedBox(height: 6),
                                                  const Text(
                                                    '￥98',
                                                    style: TextStyle(
                                                      fontSize: 12,
                                                      color: Color(0xFF939495),
                                                      decoration: TextDecoration.lineThrough,
                                                    ),
                                                  ),
                                                ]),
                                              ),
                                            ),
                                            Positioned(
                                              bottom: 0,
                                              child: Container(
                                                width: (MediaQuery.of(context).size.width - 32 - 30) / 3 - 2,
                                                height: 24,
                                                decoration: BoxDecoration(
                                                  color: const Color(0xFFAC884E),
                                                  border: Border.all(
                                                    color: const Color(0xFFAC884E),
                                                    width: 1.0,
                                                  ),
                                                  borderRadius: const BorderRadius.vertical(
                                                    bottom: Radius.circular(12.0),
                                                  ),
                                                ),
                                                child: const Center(
                                                  child: Text(
                                                    '优惠 30%',
                                                    style: TextStyle(
                                                      fontSize: 12,
                                                      color: Color(0xFFFFFFFF),
                                                    ),
                                                  ),
                                                ),
                                              ),
                                            ),
                                          ]),
                                        ),
                                      ),
                                      GestureDetector(
                                        onTap: () {
                                          setState(() {
                                            chosenIndex = 1;
                                          });
                                        },
                                        child: Container(
                                          width: (MediaQuery.of(context).size.width - 32 - 30) / 3,
                                          decoration: BoxDecoration(
                                            color: chosenIndex == 1 ? const Color(0xFFFEF9E9) : const Color(0xFFFFFFFF),
                                            border: Border.all(
                                              color: chosenIndex == 1 ? const Color(0xFFAC884E) : const Color(0xFFE2E2E2),
                                              width: 1.0,
                                            ),
                                            borderRadius: const BorderRadius.all(Radius.circular(14.0) //                 <--- border radius here
                                                ),
                                          ),
                                          child: Stack(children: [
                                            if (chosenIndex == 1)
                                              Positioned(
                                                top: 0,
                                                right: 0,
                                                child: Image.asset(
                                                  'images/vip/check.png',
                                                  width: 24,
                                                  height: 20,
                                                ),
                                              ),
                                            Positioned(
                                              top: 20,
                                              child: SizedBox(
                                                width: (MediaQuery.of(context).size.width - 32 - 30) / 3,
                                                child: Column(children: [
                                                  const Text(
                                                    '3个月',
                                                    style: TextStyle(
                                                      fontSize: 14,
                                                      fontWeight: FontWeight.w600,
                                                      color: Color(0xFF434346),
                                                    ),
                                                  ),
                                                  const SizedBox(height: 6),
                                                  Row(
                                                    mainAxisAlignment: MainAxisAlignment.center,
                                                    children: [
                                                      Image.asset(
                                                        'images/vip/rmb.png',
                                                        width: 16,
                                                        height: 14,
                                                      ),
                                                      Text(
                                                        '${payInfoList.isEmpty ? '...' : payInfoList[1]['money'] ~/ 100}',
                                                        style: const TextStyle(
                                                          fontFamily: 'SFProDisplay',
                                                          fontSize: 28,
                                                          fontWeight: FontWeight.w700,
                                                          color: Color(0xFFBB8247),
                                                        ),
                                                      ),
                                                      const SizedBox(width: 4),
                                                    ],
                                                  ),
                                                  const SizedBox(height: 6),
                                                  const Text(
                                                    '￥36',
                                                    style: TextStyle(
                                                      fontSize: 12,
                                                      color: Color(0xFF939495),
                                                      decoration: TextDecoration.lineThrough,
                                                    ),
                                                  ),
                                                ]),
                                              ),
                                            ),
                                            Positioned(
                                              bottom: 0,
                                              child: Container(
                                                width: (MediaQuery.of(context).size.width - 32 - 30) / 3 - 2,
                                                height: 24,
                                                decoration: BoxDecoration(
                                                  color: const Color(0xFFAC884E),
                                                  border: Border.all(
                                                    color: const Color(0xFFAC884E),
                                                    width: 1.0,
                                                  ),
                                                  borderRadius: const BorderRadius.vertical(
                                                    bottom: Radius.circular(12.0),
                                                  ),
                                                ),
                                                child: const Center(
                                                  child: Text(
                                                    '优惠 16%',
                                                    style: TextStyle(
                                                      fontSize: 12,
                                                      color: Color(0xFFFFFFFF),
                                                    ),
                                                  ),
                                                ),
                                              ),
                                            ),
                                          ]),
                                        ),
                                      ),
                                      GestureDetector(
                                        onTap: () {
                                          setState(() {
                                            chosenIndex = 2;
                                          });
                                        },
                                        child: Container(
                                          width: (MediaQuery.of(context).size.width - 32 - 30) / 3,
                                          decoration: BoxDecoration(
                                            color: chosenIndex == 2 ? const Color(0xFFFEF9E9) : const Color(0xFFFFFFFF),
                                            border: Border.all(
                                              color: chosenIndex == 2 ? const Color(0xFFAC884E) : const Color(0xFFE2E2E2),
                                              width: 1.0,
                                            ),
                                            borderRadius: const BorderRadius.all(Radius.circular(14.0) //                 <--- border radius here
                                                ),
                                          ),
                                          child: Stack(children: [
                                            if (chosenIndex == 2)
                                              Positioned(
                                                top: 0,
                                                right: 0,
                                                child: Image.asset(
                                                  'images/vip/check.png',
                                                  width: 24,
                                                  height: 20,
                                                ),
                                              ),
                                            Positioned(
                                              top: 20,
                                              child: SizedBox(
                                                width: (MediaQuery.of(context).size.width - 32 - 30) / 3,
                                                child: Column(children: [
                                                  const Text(
                                                    '1个月',
                                                    style: TextStyle(
                                                      fontSize: 14,
                                                      fontWeight: FontWeight.w600,
                                                      color: Color(0xFF434346),
                                                    ),
                                                  ),
                                                  const SizedBox(height: 6),
                                                  Row(
                                                    mainAxisAlignment: MainAxisAlignment.center,
                                                    children: [
                                                      Image.asset(
                                                        'images/vip/rmb.png',
                                                        width: 16,
                                                        height: 14,
                                                      ),
                                                      Text(
                                                        '${payInfoList.isEmpty ? '...' : payInfoList[2]['money'] ~/ 100}',
                                                        style: const TextStyle(
                                                          fontFamily: 'SFProDisplay',
                                                          fontSize: 28,
                                                          fontWeight: FontWeight.w700,
                                                          color: Color(0xFFBB8247),
                                                        ),
                                                      ),
                                                      const SizedBox(width: 4),
                                                    ],
                                                  ),
                                                  const SizedBox(height: 6),
                                                  const Text(
                                                    '无优惠',
                                                    style: TextStyle(
                                                      fontSize: 12,
                                                      color: Color(0xFF939495),
                                                      // decoration: TextDecoration.lineThrough,
                                                    ),
                                                  ),
                                                ]),
                                              ),
                                            ),
                                          ]),
                                        ),
                                      ),
                                    ],
                                  ),
                                ),
                                if (!Platform.isIOS) const SizedBox(height: 20),
                                if (!Platform.isIOS)
                                  Row(
                                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                    children: [
                                      GestureDetector(
                                        onTap: () async {
                                          setState(() {
                                            payMethod = 'wechat-pay';
                                          });
                                        },
                                        child: Container(
                                          width: (MediaQuery.of(context).size.width - 48 - 10) / 2,
                                          height: 50,
                                          padding: const EdgeInsets.fromLTRB(8, 0, 12, 0),
                                          decoration: const BoxDecoration(
                                            color: Color(0xFFF7F8FA),
                                            borderRadius: BorderRadius.all(Radius.circular(8.0)),
                                          ),
                                          child: SizedBox(
                                            width: (MediaQuery.of(context).size.width - 48 - 10) / 2,
                                            height: 50,
                                            child: Row(
                                              mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                              children: [
                                                Row(
                                                  children: [
                                                    Image.asset(
                                                      'images/vip/wechat-pay-fill.png',
                                                      width: 24,
                                                      height: 24,
                                                    ),
                                                    const SizedBox(width: 6),
                                                    const Text(
                                                      '微信支付',
                                                      style: TextStyle(
                                                        fontSize: 14,
                                                        color: Color(0xFF1E2128),
                                                      ),
                                                    ),
                                                  ],
                                                ),
                                                Image.asset(
                                                  'images/vip/check-circle${payMethod == 'wechat-pay' ? '-fill' : ''}.png',
                                                  width: 16,
                                                  height: 16,
                                                ),
                                              ],
                                            ),
                                          ),
                                        ),
                                      ),
                                      GestureDetector(
                                        onTap: () async {
                                          setState(() {
                                            payMethod = 'alipay';
                                          });
                                        },
                                        child: Container(
                                          width: (MediaQuery.of(context).size.width - 48 - 10) / 2,
                                          height: 50,
                                          padding: const EdgeInsets.fromLTRB(8, 0, 12, 0),
                                          decoration: const BoxDecoration(
                                            color: Color(0xFFF7F8FA),
                                            borderRadius: BorderRadius.all(Radius.circular(8.0)),
                                          ),
                                          child: SizedBox(
                                            width: (MediaQuery.of(context).size.width - 48 - 10) / 2,
                                            height: 50,
                                            child: Row(
                                              mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                              children: [
                                                Row(
                                                  children: [
                                                    Image.asset(
                                                      'images/vip/alipay-fill.png',
                                                      width: 24,
                                                      height: 24,
                                                    ),
                                                    const SizedBox(width: 6),
                                                    const Text(
                                                      '支付宝支付',
                                                      style: TextStyle(
                                                        fontSize: 14,
                                                        color: Color(0xFF1E2128),
                                                      ),
                                                    ),
                                                  ],
                                                ),
                                                Image.asset(
                                                  'images/vip/check-circle${payMethod == 'alipay' ? '-fill' : ''}.png',
                                                  width: 16,
                                                  height: 16,
                                                ),
                                              ],
                                            ),
                                          ),
                                        ),
                                      ),
                                    ],
                                  ),
                                const SizedBox(height: 24),
                                GestureDetector(
                                  onTap: () async {
                                    var isIOS = Platform.isIOS || false;
                                    if (isIOS) {
                                      EasyLoading.show(status: "正在与Apple服务器通信");

                                      // 0. 调用服务器下单接口 /pay/ios
                                      var result = await HTTP(url: '/pay/1.0/ios?payment-id=${payInfoList[chosenIndex]['id']}').request();
                                      orderNo = result['orderNo'];
                                      var productSet = <String>{result['productID']};
                                      ProductDetailsResponse response = await inAppPurchaseInstance.queryProductDetails(productSet);

                                      // 只需要填写商品ID即可
                                      final ProductDetails productDetail = response.productDetails.first;
                                      // 5. 创建购买参数
                                      final PurchaseParam purchaseParam = PurchaseParam(productDetails: productDetail);
                                      // 6. 发起购买，这里要注意避免重复购买
                                      inAppPurchaseInstance.restorePurchases(applicationUserName: result['productID']);
                                      try {
                                        InAppPurchase.instance.buyConsumable(purchaseParam: purchaseParam, autoConsume: true);
                                      } catch (e) {
                                        EasyLoading.showError("购买失败");
                                      }
                                    } else if (payMethod == 'wechat-pay') {
                                      EasyLoading.show();
                                      // 微信支付
                                      var result = await HTTP(url: '/pay/1.0/wechat?payment-id=${payInfoList[chosenIndex]['id']}').request();
                                      // print(result);

                                      payWithWeChat(
                                        appId: result['appid'],
                                        partnerId: result['partnerid'],
                                        prepayId: result['prepayid'],
                                        packageValue: result['package'],
                                        nonceStr: result['noncestr'],
                                        timeStamp: int.parse(result['timestamp']),
                                        sign: result['sign'],
                                      );
                                    } else if (payMethod == 'alipay') {
                                      // 支付宝支付
                                      EasyLoading.show();
                                      var str = await HTTP(url: '/pay/1.0/alipay?payment-id=${payInfoList[chosenIndex]['id']}').request();
                                      // print(str);
                                      try {
                                        await tobias.aliPay(str, evn: AliPayEvn.ONLINE);
                                        var res = await HTTP(url: '/pay/status').request();
                                        EasyLoading.showSuccess('支付成功');
                                        setState(() {
                                          settings['vipExpireDate'] = res['expireDate'];
                                        });
                                      } catch (err) {
                                        // print(err);
                                        var errMap = err as Map;
                                        if (errMap['errcode'] == 419) {
                                          EasyLoading.showError('支付未完成');
                                        }
                                      }
                                    }
                                  },
                                  child: Container(
                                    width: MediaQuery.of(context).size.width,
                                    height: 52,
                                    decoration: const BoxDecoration(
                                      gradient: LinearGradient(
                                        begin: Alignment.centerLeft,
                                        end: Alignment.centerRight,
                                        stops: [-0.16, 1.36],
                                        colors: [
                                          Color(0xFFFAD79D),
                                          Color(0xFFFFC96F),
                                        ],
                                      ),
                                      borderRadius: BorderRadius.all(Radius.circular(14.0)),
                                    ),
                                    child: Center(
                                      child: Text(
                                        '立即以${chosenIndex == 0 ? 68 : chosenIndex == 1 ? 25 : chosenIndex == 2 ? 12 : 128}元开通',
                                        style: const TextStyle(
                                          fontSize: 16,
                                          fontWeight: FontWeight.w600,
                                          color: Color(0xFF7D6032),
                                        ),
                                      ),
                                    ),
                                  ),
                                ),
                                const SizedBox(height: 12),
                                Row(
                                  mainAxisAlignment: MainAxisAlignment.center,
                                  children: [
                                    RichText(
                                      textAlign: TextAlign.center,
                                      text: TextSpan(
                                        children: [
                                          const TextSpan(style: TextStyle(color: Color(0xFF787878), fontSize: 14), text: '开通代表接受'),
                                          TextSpan(
                                            text: '《AceWord会员协议》',
                                            style: const TextStyle(color: Color(0xFFBB8247), fontSize: 14),
                                            recognizer: TapGestureRecognizer()
                                              ..onTap = () {
                                                Navigator.of(context).push(
                                                  MaterialPageRoute(
                                                    builder: (context) => const Browser(
                                                        url:
                                                            'https://mp.weixin.qq.com/s?__biz=MzkzNDQwMzgxNw==&mid=2247483703&idx=1&sn=43cc958a0373ddf44ca7706ac2a9db05&chksm=c2bc8ab1f5cb03a789c1d1ff8be6f2d76796859b7a7b55aad2f196f63b349f49579690794232&token=430278592&lang=zh_CN#rd',
                                                        title: '会员协议'),
                                                  ),
                                                );
                                              },
                                          ),
                                        ],
                                      ),
                                    ),
                                  ],
                                ),
                                const SizedBox(height: 24),
                              ],
                            ),
                            Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                const Text(
                                  '会员特权',
                                  style: TextStyle(
                                    fontSize: 18,
                                    fontWeight: FontWeight.w600,
                                    color: Color(0xFF1D2129),
                                  ),
                                ),
                                const SizedBox(height: 20),
                                Row(
                                  children: [
                                    Image.asset(
                                      'images/vip/feature-1.png',
                                      width: 40,
                                      height: 40,
                                    ),
                                    const SizedBox(width: 14),
                                    Column(
                                      crossAxisAlignment: CrossAxisAlignment.start,
                                      children: const [
                                        Text(
                                          '无限卡片用量',
                                          style: TextStyle(
                                            fontSize: 15,
                                            fontWeight: FontWeight.w600,
                                            color: Color(0xFF1D2129),
                                          ),
                                        ),
                                        SizedBox(height: 2),
                                        Text(
                                          '每日新建的卡片数量无上限',
                                          style: TextStyle(
                                            fontSize: 13,
                                            color: Color(0xFF929499),
                                          ),
                                        ),
                                      ],
                                    ),
                                  ],
                                ),
                                const SizedBox(height: 24),
                                Row(
                                  children: [
                                    Image.asset(
                                      'images/vip/feature-2.png',
                                      width: 40,
                                      height: 40,
                                    ),
                                    const SizedBox(width: 14),
                                    Column(
                                      crossAxisAlignment: CrossAxisAlignment.start,
                                      children: const [
                                        Text(
                                          '无限单词本、自定义词书用量',
                                          style: TextStyle(
                                            fontSize: 15,
                                            fontWeight: FontWeight.w600,
                                            color: Color(0xFF1D2129),
                                          ),
                                        ),
                                        SizedBox(height: 2),
                                        Text(
                                          '创建的单词本、自定义词书数量均无上限',
                                          style: TextStyle(
                                            fontSize: 13,
                                            color: Color(0xFF929499),
                                          ),
                                        ),
                                      ],
                                    ),
                                  ],
                                ),
                                const SizedBox(height: 24),
                                Row(
                                  children: [
                                    Image.asset(
                                      'images/vip/feature-3.png',
                                      width: 40,
                                      height: 40,
                                    ),
                                    const SizedBox(width: 14),
                                    Column(
                                      crossAxisAlignment: CrossAxisAlignment.start,
                                      children: const [
                                        Text(
                                          '批量导入自定义释义',
                                          style: TextStyle(
                                            fontSize: 15,
                                            fontWeight: FontWeight.w600,
                                            color: Color(0xFF1D2129),
                                          ),
                                        ),
                                        SizedBox(height: 2),
                                        Text(
                                          '可以通过自定义词书批量导入自定义释义',
                                          style: TextStyle(
                                            fontSize: 13,
                                            color: Color(0xFF929499),
                                          ),
                                        ),
                                      ],
                                    ),
                                  ],
                                ),
                                const SizedBox(height: 24),
                                Row(
                                  children: [
                                    Image.asset(
                                      'images/vip/feature-4.png',
                                      width: 40,
                                      height: 40,
                                    ),
                                    const SizedBox(width: 14),
                                    Column(
                                      crossAxisAlignment: CrossAxisAlignment.start,
                                      children: const [
                                        Text(
                                          '自定义复习节奏（倒计时）',
                                          style: TextStyle(
                                            fontSize: 15,
                                            fontWeight: FontWeight.w600,
                                            color: Color(0xFF1D2129),
                                          ),
                                        ),
                                        SizedBox(height: 2),
                                        Text(
                                          '可以调整复习节奏更紧凑，或更松弛',
                                          style: TextStyle(
                                            fontSize: 13,
                                            color: Color(0xFF929499),
                                          ),
                                        ),
                                      ],
                                    ),
                                  ],
                                ),
                                const SizedBox(height: 24),
                                Row(
                                  children: [
                                    Image.asset(
                                      'images/vip/feature-4.png',
                                      width: 40,
                                      height: 40,
                                    ),
                                    const SizedBox(width: 14),
                                    Column(
                                      crossAxisAlignment: CrossAxisAlignment.start,
                                      children: const [
                                        Text(
                                          '丰富的卡片英文字体',
                                          style: TextStyle(
                                            fontSize: 15,
                                            fontWeight: FontWeight.w600,
                                            color: Color(0xFF1D2129),
                                          ),
                                        ),
                                        SizedBox(height: 2),
                                        Text(
                                          '可以切换八种不同的卡片英文字体',
                                          style: TextStyle(
                                            fontSize: 13,
                                            color: Color(0xFF929499),
                                          ),
                                        ),
                                      ],
                                    ),
                                  ],
                                ),
                                const SizedBox(height: 24),
                                Row(
                                  children: [
                                    Image.asset(
                                      'images/vip/feature-6.png',
                                      width: 40,
                                      height: 40,
                                    ),
                                    const SizedBox(width: 14),
                                    Column(
                                      crossAxisAlignment: CrossAxisAlignment.start,
                                      children: const [
                                        Text(
                                          '丰富的单词背景色',
                                          style: TextStyle(
                                            fontSize: 15,
                                            fontWeight: FontWeight.w600,
                                            color: Color(0xFF1D2129),
                                          ),
                                        ),
                                        SizedBox(height: 2),
                                        Text(
                                          '可以给卡片单词标记多种背景色',
                                          style: TextStyle(
                                            fontSize: 13,
                                            color: Color(0xFF929499),
                                          ),
                                        ),
                                      ],
                                    ),
                                  ],
                                ),
                                const SizedBox(height: 24),
                              ],
                            ),
                          ],
                        )),
                  ),
                ]),
              ),
            ],
          ),
          Padding(
              padding: EdgeInsets.only(top: MediaQuery.of(context).viewPadding.top),
              child: const NaviBar(type: 'back', showDivider: false, showVantDivider: false, title: '开通会员', backgroundColor: Color(0xFF161A27), titleTextColor: Color(0xFFFFDB93))),
        ]),
      ),
    );
  }
}


 */
