part of user_love;

class UserLovePage extends StatefulWidget {
  const UserLovePage({Key? key}) : super(key: key);

  @override
  State<UserLovePage> createState() => _UserLovePageState();
}

class _UserLovePageState extends State<UserLovePage> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<UserLoveController>(
      init: UserLoveController(),
      builder:(controller) => Scaffold(
        appBar: AppBar(
          centerTitle: true,
          title: const Text('我的收藏'),
        ),
        body: Container(
          color: Colours.cF9,
          child: CustomPullScrollView(
            controller: controller.refreshController,
            onRefresh: controller.onRefresh,
            onLoading: controller.onLoading,
            child: controller.loves.isEmpty?Container(
              padding: EdgeInsets.only(top: 110.w),
              alignment: Alignment.center,
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.center,
                children: [
                  SizedBox(height: 152.w, width: 195.w,
                    child: Image.asset( 'assets/images/none.png',),),
                  SizedBox(height: 13.w,),
                ],
              ),
            ):ListView.builder(
              itemBuilder: (BuildContext context, int index){
                CourseModel model = controller.loves[index];
                return GestureDetector(
                  onTap: (){
                    if(model.status == 0 && model.isHave == 0){
                      Toast.show('书籍已下架');
                    }
                    else{
                      context.pushNamed(Routes.bookDetail,queryParameters: {'book_id':model.bookId.toString()});
                    }
                  },
                  child: BuildItem(model: model,onTap: (){
                    controller.unLoved(bookId: model.bookId.toString());
                  },),
                );
              },
              itemCount: controller.loves.length,
            ),
          ),
        ),
      ),
    );
  }
}
