import DropListMenu from '../menu-constructors/DropListMenu'
import $ from '../../utils/dom-core'
import { createMemuElem } from '../../utils/util'
import Editor from '../../editor/index'
import OperatorList from '../common/InlineBlockList'

class Chemistry extends DropListMenu {
  constructor(editor: Editor) {
    const $elem = $(createMemuElem('H_{2}O'))
    const presetList = new OperatorList(editor.menusConfig.chemistry)
    const presetConf = {
      title: editor.t('fe.c'),
      list: presetList.getItemList(),
      clickHandler: (value: string) => {
        this.command(value)
      },
    }
    super($elem, editor, presetConf)
  }
}

export default Chemistry
