import { DomEditor, SlateTransforms as Transforms, SlateRange } from '@wangeditor/editor'

// Extend menu
class ImageAuto {
  constructor() {
    this.title = '图片'
    this.iconSvg = `<svg width="23px" height="21px" viewBox="0 0 23 21" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <title>编辑器图片样式</title>
    <g id="页面-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g id="图标" transform="translate(-500.000000, -387.000000)" fill="#BCBCBC" fill-rule="nonzero">
            <g id="图片-(1)" transform="translate(500.000000, 387.000000)">
                <path d="M23,0 L23,21 L0,21 L0,0 L23,0 Z M17.9968611,10.9295455 L11.5159722,16.3017273 L7.30633333,12.9939091 L1.91666667,17.3351818 L1.91666667,19.0909091 L21.0833333,19.0909091 L21.0833333,13.4794546 L17.9968611,10.9295455 Z M21.0833333,1.90909091 L1.91666667,1.90909091 L1.91666667,14.8800909 L7.29163888,10.5509091 L11.4833889,13.8447273 L17.9955833,8.44836363 L21.0833333,10.9989091 L21.0833333,1.90909091 Z M7.98611109,3.18181819 C9.57392975,3.18181819 10.8611111,4.46391186 10.8611111,6.04545456 C10.8611111,7.62699725 9.57392975,8.90909092 7.98611109,8.90909092 C6.39829244,8.90909092 5.11111109,7.62699725 5.11111109,6.04545456 C5.11111109,4.46391186 6.39829244,3.18181819 7.98611109,3.18181819 Z M7.98611109,5.0909091 C7.45683821,5.0909091 7.02777776,5.51827366 7.02777776,6.04545456 C7.02777776,6.57263545 7.45683821,7.00000001 7.98611109,7.00000001 C8.51538398,7.00000001 8.94444442,6.57263545 8.94444442,6.04545456 C8.94444442,5.51827366 8.51538398,5.0909091 7.98611109,5.0909091 Z" id="形状"></path>
            </g>
        </g>
    </g>
</svg>`
    this.tag = 'button'
  }
  getValue(editor) {
    return 'hello, 图片, , , 图片'
  }
  isActive(editor) {
    return false // or true
  }
  isDisabled(editor) {
    const { selection } = editor
    if (selection === null) return true
    if (SlateRange.isExpanded(selection)) return true // 选区非折叠，禁用

    const selectedElems = DomEditor.getSelectedElems(editor)

    const hasVoidElem = selectedElems.some(elem => editor.isVoid(elem))
    if (hasVoidElem) return true // 选中了 void 元素，禁用

    // eslint-disable-next-line array-callback-return
    const hasPreElem = selectedElems.some(elem => {
      const type = DomEditor.getNodeType(elem)
      // 代码块 引用 表格 禁用
      if (type === 'pre' || type === 'blockquote') return true
    })
    if (hasPreElem) return true // 选中了 pre 原则，禁用

    return false
  }
  getSelectedNode(editor) {
    return DomEditor.getSelectedNodeByType(editor, 'chapterImage')
  }
  exec(editor, value) {
    // editor.insertText(value) // value 即 this.getValue(editor) 的返回值

    editor.emit('ImageMenuClick')

    if (this.isDisabled(editor)) {
      return
    }

    const imageNode = this.getSelectedNode(editor)
    if (imageNode === null) return

    // 隐藏 hoverbar
    const hoverbar = DomEditor.getHoverbar(editor)
    if (hoverbar) hoverbar.hideAndClean()

    const { style = {} } = imageNode
    const props = {
      style: {
        ...style,
        width: this.value, // 修改 width
        height: '' // 清空 height
      }
    }

    Transforms.setNodes(editor, props, {
      match: n => DomEditor.checkNodeType(n, 'chapterImage')
    })
  }
}

class ImageWidthCustomer100 extends ImageAuto {
  title = '100%' // 菜单标题
  value = '100%' // css width 的值
}

class ImageWidthCustomer50 extends ImageAuto {
  title = '50%' // 菜单标题
  value = '50%' // css width 的值
}

class ImageWidthCustomer30 extends ImageAuto {
  title = '30%' // 菜单标题
  value = '30%' // css width 的值
}

export default {
  key: 'ImageAuto', // 定义 menu key ：要保证唯一、不重复（重要）
  factory() {
    return new ImageAuto() // 把 `YourMenuClass` 替换为你菜单的 class
  }
}

const imageWidth100MenuChapterConf = {
  key: 'imageWidthChpater100',
  factory() {
    return new ImageWidthCustomer100()
  }
}

const imageWidth50MenuChapterConf = {
  key: 'imageWidthChpater50',
  factory() {
    return new ImageWidthCustomer50()
  }
}

const imageWidth30MenuChapterConf = {
  key: 'imageWidthChpater30',
  factory() {
    return new ImageWidthCustomer30()
  }
}

export { ImageAuto, imageWidth100MenuChapterConf, imageWidth50MenuChapterConf, imageWidth30MenuChapterConf }
