class RemoveSpaces {
  constructor() {
    this.title = '去空格'
    this.iconSvg = `<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16"><path fill="currentColor" d="M2 2h12v12H2V2zm1 1v10h10V3H3zm2 2h6v1H5V5zm0 2h6v1H5V7zm0 2h4v1H5V9z"/></svg>`
    this.tag = 'button'
  }

  // eslint-disable-next-line no-unused-vars
  getValue(editor) {
    return ''
  }

  // eslint-disable-next-line no-unused-vars
  isActive(editor) {
    return false
  }

  // eslint-disable-next-line no-unused-vars
  isDisabled(editor) {
    return false
  }

  exec(editor) {
    // 获取当前 HTML
    const html = editor.getHtml()

    if (!html) {
      return
    }

    // 使用正则表达式去除 HTML 标签之间文本的空格
    // 匹配 >文本< 之间的内容，去除空格字符（包括多个相邻的空格）和 &nbsp;，保留其他字符和标签结构
    const htmlWithoutSpaces = html.replace(/>([^<]*?)</g, (match, text) => {
      // 先去除所有的 &nbsp; HTML 实体
      let textWithoutSpaces = text.replace(/&nbsp;+/gi, '')
      // 然后去除所有空格字符（包括多个相邻的空格），保留其他字符
      textWithoutSpaces = textWithoutSpaces.replace(/ +/g, '')
      return `>${textWithoutSpaces}<`
    })

    // 如果内容有变化，设置回去
    if (htmlWithoutSpaces !== html) {
      // 设置处理后的 HTML
      editor.setHtml(htmlWithoutSpaces)
    }
  }
}

export default {
  key: 'RemoveSpaces', // 定义 menu key ：要保证唯一、不重复（重要）
  factory() {
    return new RemoveSpaces()
  },
}

export { RemoveSpaces }
