import BaseModalMenu from './common/BaseModalMenu'
import AIModal from './common/AIModal'

class AIPolishing extends BaseModalMenu {
  constructor() {
    super()

    this.title = '润色'
    this.iconSvg = `<svg width="48px" height="48px" viewBox="0 0 48 48" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <g id="页面-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g id="图标" transform="translate(-536, -221)" fill="#333333" fill-rule="nonzero">
            <g id="润色-(1)" transform="translate(536, 221)">
                <path d="M1.95471575,0 L44.9584623,0 C46.2616061,0 46.913178,0.678713837 46.913178,2.03614151 L46.913178,2.03614151 C46.913178,3.39356919 46.2616061,4.07228302 44.9584623,4.07228302 L1.95471575,4.07228302 C0.651571917,4.07228302 0,3.39356919 0,2.03614151 L0,2.03614151 C0,0.678713837 0.651571917,0 1.95471575,0 Z" id="路径"></path>
                <path d="M1.95471575,12.2168491 L29.3207363,12.2168491 C30.6238801,12.2168491 31.275452,12.8955629 31.275452,14.2529906 L31.275452,14.2529906 C31.275452,15.6104183 30.6238801,16.2891321 29.3207363,16.2891321 L1.95471575,16.2891321 C0.651571917,16.2891321 0,15.6104183 0,14.2529906 L0,14.2529906 C0,12.8955629 0.651571917,12.2168491 1.95471575,12.2168491 Z" id="路径"></path>
                <path d="M1.95471575,24.4336981 L17.5924418,24.4336981 C18.8955856,24.4336981 19.5471575,25.112412 19.5471575,26.4698397 L19.5471575,26.4698397 C19.5471575,27.8272673 18.8955856,28.5059812 17.5924418,28.5059812 L1.95471575,28.5059812 C0.651571917,28.5059812 0,27.8272673 0,26.4698397 L0,26.4698397 C0,25.112412 0.651571917,24.4336981 1.95471575,24.4336981 Z" id="路径"></path>
                <path d="M44.5362437,34.9727666 L36.4437205,39.5744464 L32.0221534,48 L27.6005864,39.5744464 L19.5158821,34.9727666 L27.6005864,30.3670145 L32.0221534,21.9373886 L36.439811,30.3670145 L44.5323343,34.9686943 L44.5362437,34.9727666 Z M44.7238964,23.712904 L48,22.7151947 L47.0421893,26.1277679 L48,29.5484856 L44.7238964,28.5385594 L41.4438834,29.5444133 L42.4056035,26.1318402 L41.4438834,22.7151947 L44.719987,23.712904 L44.7238964,23.712904 Z M20.1453005,41.4762026 L22.5965141,40.7228302 L21.8771787,43.280224 L22.5926047,45.8376177 L20.1374817,45.0842454 L17.6862681,45.8376177 L18.4056035,43.280224 L17.6901776,40.7228302 L20.1413911,41.4721303 L20.1413911,41.4762026 L20.1453005,41.4762026 Z" id="形状"></path>
            </g>
        </g>
    </g>
</svg>`
  }
  getValue(editor) {
    return <AIModal key={Date.now()} editor={editor} action="abbreviate"></AIModal>
  }
}

export default {
  key: 'AIPolishing', // 定义 menu key ：要保证唯一、不重复（重要）
  factory() {
    return new AIPolishing() // 把 `YourMenuClass` 替换为你菜单的 class
  }
}
