import BaseModalMenu from './common/BaseModalMenu'
import AIModal from './common/AIModal'

class AISummary extends BaseModalMenu {
  constructor() {
    super()

    this.title = '总结'
    this.iconSvg = `<svg width="48px" height="48px" viewBox="0 0 48 48" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <g id="页面-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g id="图标" transform="translate(-821, -216)" fill="#333333" fill-rule="nonzero">
            <g id="总结" transform="translate(821, 216)">
                <path d="M26.6441598,38.5473827 L8.91996986,38.5473827 C7.91439337,38.5473827 7.09691032,37.7200613 7.09691032,36.7023827 C7.09691032,35.6847042 7.91439337,34.8573827 8.91996986,34.8573827 L26.6513941,34.8573827 C27.6569706,34.8573827 28.4744537,35.6847042 28.4744537,36.7023827 C28.4744537,37.7200613 27.6569706,38.5473827 26.6441598,38.5473827 L26.6441598,38.5473827 Z M38.957046,30.7662342 L8.91996986,30.7662342 C7.91439337,30.7662342 7.09691032,29.9389128 7.09691032,28.9212342 C7.09691032,27.9035556 7.91439337,27.0762342 8.91996986,27.0762342 L38.957046,27.0762342 C39.9626225,27.0762342 40.7801055,27.9035556 40.7801055,28.9212342 C40.7801055,29.9389128 39.9626225,30.7662342 38.957046,30.7662342 Z" id="形状"></path>
                <path d="M43.4061794,48 L4.60105501,48 C2.06902788,48 0,46.4685996 0,44.5825591 L0,3.41744095 C0,1.53677376 2.06179352,0 4.60105501,0 L43.398945,0 C45.9309721,0 48,1.53140043 48,3.41744095 L48,44.5879324 C48,46.4685996 45.9382065,48 43.4061794,48 L43.4061794,48 Z M4.60105501,3.29183925 C4.08018086,3.29183925 3.65335343,3.59711436 3.65335343,3.96965348 L3.65335343,43.614025 C3.65335343,43.9865641 4.08018086,44.2918392 4.60105501,44.2918392 L43.398945,44.2918392 C43.9198191,44.2918392 44.3466466,43.9865641 44.3466466,43.614025 L44.3466466,3.96965348 C44.3466466,3.59711436 43.9198191,3.29183925 43.398945,3.29183925 L4.60105501,3.29183925 Z" id="形状"></path>
                <polygon id="路径" points="28.1307484 21.6324863 19.1850286 14.3892309 11.5231535 20.3375126 8.10414469 17.6347252 19.2605489 8.98365611 28.3435783 16.3397515 36.8361764 10.2840031 40.1041447 13.0942572"></polygon>
            </g>
        </g>
    </g>
</svg>`
  }
  getValue(editor) {
    return <AIModal key={Date.now()} editor={editor} action="summary"></AIModal>
  }
}

export default {
  key: 'AISummary',
  factory() {
    return new AISummary()
  }
}
