import ReactDOM from 'react-dom/client'

import { ConfigProvider, App } from 'antd'
import zhCN from 'antd/locale/zh_CN'

export default class BaseModalMenu {
  constructor() {
    this.tag = 'button'
    this.$el = document.createElement('div')
    document.body.appendChild(this.$el)
    this.$root = ReactDOM.createRoot(this.$el)
  }
  isActive() {
    return false // or true
  }
  isDisabled() {
    return false // or true
  }
  exec(editor, value) {
    this.$root.render(
      <ConfigProvider locale={zhCN} theme={{ token: { colorPrimary: '#ab1941' } }}>
        <App>{value}</App>
      </ConfigProvider>
    )
  }
}
