export const fontFamilyList = [
  { name: '思源黑体', value: '思源黑体' },
  { name: '思源宋体', value: '思源宋体' },
  { name: '黑体', value: '黑体' },
  { name: '宋体', value: '宋体' },
  { name: '楷体', value: '楷体' },
  { name: '仿宋', value: '仿宋' }
]

export const fontSizeList = [
  { name: '初号', value: 56 },
  { name: '小初', value: 48 },
  { name: '一号', value: 34 },
  { name: '小一', value: 32 },
  { name: '二号', value: 29 },
  { name: '小二', value: 24 },
  { name: '三号', value: 21 },
  { name: '小三', value: 20 },
  { name: '四号', value: 18 },
  { name: '小四', value: 16 },
  { name: '五号', value: 14 },
  { name: '小五', value: 12 },
  { name: '六号', value: 10 },
  { name: '小六', value: 8 },
  { name: '七号', value: 7 },
  { name: '八号', value: 6 }
]

export const lineHeightList = ['1', '1.25', '1.5', '2', '2.5', '3']


export const findElementPath = (editor, elementType) => {
  const { children } = editor

  // 递归函数来遍历节点
  function traverseNodes(node) {
    if (Array.isArray(node)) {
      for (let i = 0; i < node.length; i++) {
        const child = node[i]
        traverseNodes(child)
        if (child.type === elementType) {
          // 当找到匹配的元素类型时，返回其路径
          return [i, ...traverseNodes(child)]
        }
      }
    } else if (node.type === elementType) {
      // 如果当前节点是元素节点且类型匹配，则返回其路径
      return [traverseNodes(node.parent)]
    }
    return null
  }

  // 从文档的根节点开始遍历
  const path = traverseNodes(children)
  return path
}

export const findNodeWithParent = (node, type, key = 'random', value) => {
  const path = [] // 用于存储当前节点的路径
  // 递归遍历节点的辅助函数
  function traverse(nodes, type, key, value) {
    for (let i = 0; i < nodes.length; i++) {
      const current = nodes[i]
      if (current.type === type && String(current[key]) === String(value)) {
        // 找到匹配的节点，将索引添加到路径数组中
        path.push(i)
        return true
      }
      if (Array.isArray(current.children) && traverse(current.children, type, key, value)) {
        // 如果子节点中找到匹配的节点，添加当前节点的索引到路径
        path.push(i)
        return true
      }
    }
    return false // 未找到匹配的节点
  }
  // 从根节点开始遍历
  traverse(node, type, key, value)
  return path // 返回找到的路径，如果没有找到则返回空数组
}
