import MarkdownIt from 'markdown-it'
import hljs from 'highlight.js'

export default function MarkdownRender({ children }) {
  const md = new MarkdownIt({
    html: true,
    highlight: function (str, lang) {
      if (lang && hljs.getLanguage(lang)) {
        try {
          return hljs.highlight(str, { language: lang }).value
        } catch (__) {
          console.log(__)
        }
      }
      return '' // use external default escaping
    },
  })
  const renderedMarkdown = md.render(children)

  return <div className="markdown-content" dangerouslySetInnerHTML={{ __html: renderedMarkdown }} />
}
