import { Menu, Button } from 'antd'
import { LeftOutlined } from '@ant-design/icons'
import { useLocation, useNavigate } from 'react-router-dom'

export default function Breadcrumb({ menuList }) {
  const { pathname } = useLocation()
  const navigate = useNavigate()

  const currentMenusList =
    menuList.find(item => {
      const regExp = new RegExp(`^${item.path}`)
      return regExp.test(pathname)
    })?.children || []
  const selectedKeys = currentMenusList
    .filter(item => {
      const regExp = new RegExp(`^${item.path}`)
      return regExp.test(pathname)
    })
    .map(item => item.key)
  // const hasBack = currentMenusList.find(item => {
  //   const regExp = new RegExp(`^${item.path}`)
  //   return regExp.test(pathname) && item.path !== pathname
  // })
  const hasBack = [
    '/books/management/add-edit',
    '/setting/help/addedit',
    '/books/management/chapter',
    '/userinfo',
    '/books/audit/detail',
    '/books/sale/discussP',
    '/books/sale/discuss-detail',
    '/member/list/detail',
    '/books/sale/detail'
  ].includes(pathname)

  return (
    <div className="layout-breadcrumb">
      <div>
        {hasBack && (
          <Button type="text" icon={<LeftOutlined />} onClick={() => navigate(-1)}>
            返回
          </Button>
        )}
      </div>
      <Menu className="menu" mode="horizontal" items={currentMenusList} selectedKeys={selectedKeys} style={{ border: 'none' }} />
    </div>
  )
}
