// import { StrictMode } from 'react'
import { createRoot } from 'react-dom/client'
import { BrowserRouter } from 'react-router-dom'

import { Provider } from 'react-redux'
import { PersistGate } from 'redux-persist/integration/react'
import store, { persistor } from '@/store'

import { ConfigProvider, App } from 'antd'
import 'dayjs/locale/zh-cn'
import zhCN from 'antd/locale/zh_CN'

import MyApp from './App.jsx'

createRoot(document.getElementById('root')).render(
  // <StrictMode>
  <Provider store={store}>
    <PersistGate loading={null} persistor={persistor}>
      <ConfigProvider locale={zhCN} theme={{ token: { colorPrimary: '#ab1941' } }}>
        <App>
          <BrowserRouter>
            <MyApp />
          </BrowserRouter>
        </App>
      </ConfigProvider>
    </PersistGate>
  </Provider>
  // </StrictMode>
)
