import axios from '@/utils/request.js';
import qs from 'qs';
import { get } from 'lodash-es';
import { message } from 'antd';
// 题目列表
const getList = async (obj) => {
  const res = await axios.post('/book/question/getList', qs.stringify(obj));
  const code = get(res, 'data.code', 0);
  const data = get(res, 'data.data', []);
  const msg = get(res, 'data.message', '数据获取失败！');
  if (code === 200) {
    return data;
  } else {
    message.error(msg);
    return false;
  }
};
// add
const questionAdd = async (obj) => {
  const res = await axios.post('/book/question/add', qs.stringify(obj));
  const code = get(res, 'data.code', 0);
  const data = get(res, 'data.data', []);
  const msg = get(res, 'data.message', '数据获取失败！');
  if (code === 200) {
    message.success(msg);
    return true;
  } else {
    message.error(msg);
    return false;
  }
};
// info
const questionInfo = async (obj) => {
  const res = await axios.post('/book/question/getInfoById', qs.stringify(obj));
  const code = get(res, 'data.code', 0);
  const data = get(res, 'data.data', {});
  const msg = get(res, 'data.message', '数据获取失败！');
  if (code === 200) {
    return data;
  } else {
    message.error(msg);
    return false;
  }
};
// edit
const questionEdit = async (obj) => {
  const res = await axios.post('/book/question/edit', qs.stringify(obj));
  const code = get(res, 'data.code', 0);
  const data = get(res, 'data.data', []);
  const msg = get(res, 'data.message', '数据获取失败！');
  if (code === 200) {
    message.success(msg);
    return true;
  } else {
    message.error(msg);
    return false;
  }
};

// const questionEdit = async (obj) => {
//   const res = await axios.post('/book/question/edit', qs.stringify(obj));
//   const code = get(res, 'data.code', 0);
//   const data = get(res, 'data.data', []);
//   const msg = get(res, 'data.message', '数据获取失败！');
//   if (code === 200) {
//     // const id = get(data, 'id', null);
//     message.success(msg);
//     return true;
//     // return id; // 返回题目的 ID
//   } else {
//     message.error(msg);
//     return null; // 或者返回适当的错误值
//   }
// };

// del
const questionDel = async (obj) => {
  const res = await axios.post('/book/question/del', qs.stringify(obj));
  const code = get(res, 'data.code', 0);
  const data = get(res, 'data.data', []);
  const msg = get(res, 'data.message', '数据获取失败！');
  if (code === 200) {
    message.success(msg);
    return true;
  } else {
    message.error(msg);
    return false;
  }
};
// 导入题库
const questionImport = async (obj) => {
  const res = await axios.post('/book/question/import', obj, {
    headers: {
      'Content-Type': '	multipart/form-data',
    },
  });
  const code = get(res, 'data.code', 0);
  const data = get(res, 'data.data', []);
  const msg = get(res, 'data.message', '数据获取失败！');
  if (code === 200) {
    return { msg, data };
  } else {
    message.error(msg);
    return false;
  }
};
// 添加题目分类
const questionAddType = async (obj) => {
  const res = await axios.post('/book/question/type/add', qs.stringify(obj));
  const code = get(res, 'data.code', 0);
  const data = get(res, 'data.data', []);
  const msg = get(res, 'data.message', '数据获取失败！');
  if (code === 200) {
    message.success(msg);
    return data;
  } else {
    message.error(msg);
    return false;
  }
};
// 题目分类列表
const typeList = async (obj) => {
  const res = await axios.post('/book/question/type/getList', qs.stringify(obj));
  const code = get(res, 'data.code', 0);
  const data = get(res, 'data.data', []);
  const msg = get(res, 'data.message', '数据获取失败！');
  if (code === 200) {
    return data;
  } else {
    message.error(msg);
    return false;
  }
};

// 书籍名称下拉列表
const bookNameList = async (obj) => {
  const res = await axios.post('book/teacher/getListAll', qs.stringify(obj));
  const code = get(res, 'data.code', 0);
  const data = get(res, 'data.data', []);
  const msg = get(res, 'data.message', '数据获取失败！');
  if (code === 200) {
    return data;
  } else {
    message.error(msg);
    return false;
  }
};

const getAliOSSSTSToken = async (obj) => {
  try {
    const res = await axios.post('/common/OssUpload/getUploadToken', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '获取OSS令牌失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
export {
  getList,
  questionAdd,
  questionInfo,
  questionEdit,
  questionDel,
  questionImport,
  questionAddType,
  typeList,
  getAliOSSSTSToken,
  bookNameList,
};
