import axios from '@/utils/request.js';
import qs from 'qs';
import { get } from 'lodash-es';
import { message } from 'antd';
// 在售列表
const getList = async (obj) => {
  const res = await axios.post('/book/book/getList', qs.stringify(obj));
  const code = get(res, 'data.code', 0);
  const data = get(res, 'data.data', []);
  const msg = get(res, 'data.message', '数据获取失败！');
  if (code === 200) {
    return data;
  } else {
    message.error(msg);
    return false;
  }
};
// 上下架
const changeStatus = async (obj) => {
  const res = await axios.post('/book/book/changeStatus', qs.stringify(obj));
  const code = get(res, 'data.code', 0);
  const data = get(res, 'data.data', []);
  const msg = get(res, 'data.message', '数据获取失败！');
  if (code === 200) {
    message.success(msg);
    return true;
  } else {
    message.error(msg);
    return false;
  }
};
// 章节列表
const getListAll = async (obj) => {
  const res = await axios.post('/book/chapter/getListAll', qs.stringify(obj));
  const code = get(res, 'data.code', 0);
  const data = get(res, 'data.data', []);
  const msg = get(res, 'data.message', '数据获取失败！');
  if (code === 200) {
    return data;
  } else {
    message.error(msg);
    return false;
  }
};

// 详情
const getInfoById = async (obj) => {
  const res = await axios.post('/book/book/getInfoById', qs.stringify(obj));
  const code = get(res, 'data.code', 0);
  const data = get(res, 'data.data', []);
  const msg = get(res, 'data.message', '数据获取失败！');
  if (code === 200) {
    return data;
  } else {
    message.error(msg);
    return false;
  }
};
// 出品方列表
const publisherList = async (obj) => {
  const res = await axios.post('/book/publisher/getListAll', qs.stringify(obj));
  const code = get(res, 'data.code', 0);
  const data = get(res, 'data.data', []);
  const msg = get(res, 'data.message', '数据获取失败！');
  if (code === 200) {
    return data;
  } else {
    message.error(msg);
    return false;
  }
};
// 出品方添加
const publisherAdd = async (obj) => {
  const res = await axios.post('/book/publisher/add', qs.stringify(obj));
  const code = get(res, 'data.code', 0);
  const data = get(res, 'data.data', []);
  const msg = get(res, 'data.message', '数据获取失败！');
  if (code === 200) {
    message.success(msg);
    return true;
  } else {
    message.error(msg);
    return false;
  }
};
// 编辑
const editBook = async (obj) => {
  try {
    const res = await axios.post('/book/book/edit', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      message.success(msg);
      return true;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
// 话题列表
const getCommentList = async (obj) => {
  try {
    const res = await axios.post('/comment/comment/getCommentList', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
// 话题详情列表
const getCommentInfo = async (obj) => {
  try {
    const res = await axios.post('/comment/comment/getCommentInfo', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
// 删除讨论
const commentDel = async (obj) => {
  try {
    const res = await axios.post('/comment/comment/del', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      message.success(msg);
      return true;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
// 回复讨论
const commentReply = async (obj) => {
  try {
    const res = await axios.post('/comment/comment/reply', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      message.success(msg);
      return true;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
export {
  getList,
  changeStatus,
  getListAll,
  getInfoById,
  publisherList,
  publisherAdd,
  editBook,
  getCommentList,
  getCommentInfo,
  commentDel,
  commentReply,
};
