import axios from '@/utils/request.js';
import qs from 'qs';
import { get } from 'lodash-es';
import { message } from 'antd';
// 管理员列表
const getList1 = async (obj) => {
  try {
    const res = await axios.post('/user/user/getList', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
// 添加
const addRole = async (obj) => {
  try {
    const res = await axios.post('/user/user/add', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      message.success(msg);
      return true;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
// 详情
const infoRole = async (obj) => {
  try {
    const res = await axios.post('/user/user/getInfoById', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
// 修改
const editRole = async (obj) => {
  try {
    const res = await axios.post('/user/user/edit', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      message.success(msg);
      return true;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
// 删除
const delRole = async (obj) => {
  try {
    const res = await axios.post('/user/user/del', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      message.success(msg);
      return true;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
const changeStatus = async (obj) => {
  try {
    const res = await axios.post('/user/user/changeStatus', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      message.success(msg);
      return true;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
// 修改密码
const editPass = async (obj) => {
  try {
    const res = await axios.post('/user/user/editPass', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      message.success(msg);
      return true;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
export { getList1, addRole, infoRole, editRole, changeStatus, delRole, editPass };
