import React, { useEffect, useState } from 'react';
import { Segmented, Button } from 'antd';
import { Outlet, useNavigate, useLocation } from 'react-router-dom';

import CouponRecord from './CouponRecord';
import OrderRecord from './orderRecord';
import IntegralRecord from './IntegralRecord';

const UserDetail = () => {
  const navigate = useNavigate();
  const location = useLocation();
  const options = [
    {
      label: '订单记录',
      key: 'order-record',
      value: 1,
    },
    {
      label: '积分记录',
      key: 'integral-record',
      value: 2,
    },
    {
      label: '优惠券记录',
      key: 'coupon-record',
      value: 3,
    },
  ];
  const [currentVal, setCurrentVal] = useState(1);
  useEffect(() => {
    let val = options.find((item) => {
      if (location.pathname.includes(item.key)) {
        return item;
      }
    });
    if (val) {
      setCurrentVal(val.value);
    }
  }, []);
  const onChange = (value) => {
    setCurrentVal(value);
  };
  return (
    <div>
      <Segmented
        options={options}
        onChange={onChange}
        defaultValue={currentVal}
        style={{ marginBottom: 20 }}
        value={currentVal}
      ></Segmented>
      {/* <Outlet/> */}
      {currentVal === 3 && <CouponRecord id={location.state.id} />}
      {currentVal === 2 && <IntegralRecord id={location.state.id} />}
      {currentVal === 1 && <OrderRecord id={location.state.id} />}
    </div>
  );
};
export default UserDetail;
