import React, { useEffect, useState } from 'react';
import {
  Table,
  Input,
  Button,
  Row,
  Col,
  Space,
  DatePicker,
  Pagination,
  Drawer,
  Form,
  Select,
} from 'antd';
const { RangePicker } = DatePicker;
import { useLocation } from 'react-router-dom';
import PaginationCom from '@/common/Pagination/index.jsx';
import { getOrdersList } from '../list/request';
import TableCom from '@/common/TableCom/index';
const OrderRecord = (props) => {
  const { id } = props;
  const [data, setData] = useState([]);
  const [page_size, setpage_size] = useState(10);
  const [page, setPage] = useState(1);
  const [total, setTotal] = useState(0);
  const [loading, setLoading] = useState(true);
  const [isEdit, setIsEdit] = useState(false);
  const [form] = Form.useForm();
  const init = async (obj = {}) => {
    setLoading(true);
    const { total, list } = await getOrdersList({ id });
    setTotal(total);
    setData(list);
    setLoading(false);
  };
  const columns = [
    {
      title: '订单编号',
      key: 'id',
      dataIndex: 'id',
      align: 'center',
    },
    {
      title: '书籍名称',
      key: 'book_name',
      dataIndex: 'book_name',
      align: 'center',
    },
    {
      title: '总金额',
      key: 'total_price',
      dataIndex: 'total_price',
      align: 'center',
    },
    {
      title: '实际付款金额',
      key: 'final_total_price',
      dataIndex: 'final_total_price',
      align: 'center',
    },
    {
      title: '下单时间',
      key: 'create_time',
      dataIndex: 'create_time',
      align: 'center',
    },
    {
      title: '支付时间',
      key: 'pay_time',
      dataIndex: 'pay_time',
      align: 'center',
    },
    {
      title: '支付方式',
      key: 'pay_type_text', // 修改key，避免与原始数据冲突
      dataIndex: 'pay_type',
      align: 'center',
      render: (_, record) => {
        switch (record.pay_type) {
          case 1:
            return '微信';
          case 2:
            return '支付宝';
          case 3:
            return '紫荆币';
          default:
            return '-';
        }
      },
    },
    {
      title: '结算状态',
      key: 'status',
      dataIndex: 'status',
      align: 'center',
      render: (_, record) => {
        switch (record.pay_type) {
          case 1:
            return '待支付';
          case 2:
            return '取消支付';
          case 3:
            return '已支付';
          default:
            return '-';
        }
      },
    },
  ];
  return (
    <div>
      {TableCom({ columns, loading, data })}

      <br />
      <PaginationCom
        total={total}
        page_size={page_size}
        setpage_size={setpage_size}
        page={page}
        setPage={setPage}
        init={init}
      />
    </div>
  );
};

export default OrderRecord;
