import axios from '@/utils/request.js';
import qs from 'qs';
import { get } from 'lodash-es';
import { message } from 'antd';
// 优惠券列表
const getList = async (obj) => {
  try {
    const res = await axios.post('/system/coupon/getList', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
// 添加优惠券
const addCoupon = async (obj) => {
  try {
    const res = await axios.post('/system/coupon/add', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      message.success(msg);
      return true;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return error;
  }
};
// 修改优惠券
const editCoupon = async (obj) => {
  try {
    const res = await axios.post('/system/coupon/edit', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      message.success(msg);
      return true;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return error;
  }
};
// 删除优惠券
const delCoupon = async (obj) => {
  try {
    const res = await axios.post('/system/coupon/del', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      message.success(msg);
      return true;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return error;
  }
};
// 优惠券发放

const recordCoupon = async (obj) => {
  try {
    const res = await axios.post('/system/coupon/record/add', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');

    if (code === 3000) {
      message.warning('优惠券已过期');
      return true;
    }

    // 先检查空手机号的情况，如果满足就跳出后续错误提示
    if (
      data.err.msg === '  手机号：' &&
      data.suc.title &&
      !data.suc.title.includes('下发成功（0）')
    ) {
      if (data.suc.msg !== '') {
        message.success(`${data.suc.msg}下发成功`, 10);
      }
      message.error(`空手机号下发失败`, 10);
      return true;
    }

    // 接下来处理其他非空错误消息和成功消息

    if (data.suc.title && !data.suc.title.includes('下发成功（0）')) {
      if (data.suc.msg !== '') {
        message.success(`${data.suc.msg}下发成功`, 10);
      }
    }
    if (data.err.title && !data.err.title.includes('下发失败（0）')) {
      if (data.err.msg !== '') {
        message.error(`${data.err.msg}下发失败`, 10);
      }
    }

    return true;
  } catch (error) {
    return error;
  }
};

// 获取优惠券开关
const getCoupon = async (obj) => {
  try {
    const res = await axios.post('/system/config/getCoupon', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return error;
  }
};
// 设置优惠券开关
const setCoupon = async (obj) => {
  try {
    const res = await axios.post('/system/config/couponEdit', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      message.success(msg);
      return true;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return error;
  }
};
// 详情
const getInfoById = async (obj) => {
  try {
    const res = await axios.post('/system/coupon/getInfoById', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return error;
  }
};
export {
  getList,
  addCoupon,
  editCoupon,
  delCoupon,
  recordCoupon,
  getCoupon,
  setCoupon,
  getInfoById,
};
