import { Input, DatePicker, Popover } from 'antd'
import AppList from '@/components/list'
import { getList } from './api'
const { RangePicker } = DatePicker

export default function FeedBack() {
  const remote = {
    request: getList,
    beforeRequest(params) {
      const { time, ...rest } = params
      if (time) {
        rest.start_time = new Date(time[0]).getTime() / 1000
        rest.end_time = new Date(time[1]).getTime() / 1000
      }
      return rest
    }
  }
  const filters = [
    {
      label: '用户名称',
      name: 'name',
      element: <Input placeholder="请输入用户名称" allowClear />
    },
    {
      label: '手机号',
      name: 'phone',
      element: <Input placeholder="请输入手机号" allowClear />
    },
    {
      label: '反馈时间',
      name: 'time',
      element: <RangePicker allowClear />
    }
  ]
  const columns = [
    {
      title: 'ID',
      key: 'id',
      dataIndex: 'id'
    },
    {
      title: '用户名称',
      key: 'name',
      dataIndex: 'name',
      align: 'center'
    },
    {
      title: '手机号',
      key: 'phone',
      dataIndex: 'phone',
      align: 'center'
    },
    {
      title: '反馈时间',
      key: 'create_time',
      dataIndex: 'create_time',
      align: 'center'
    },
    {
      title: '反馈内容',
      key: 'proposal',
      dataIndex: 'proposal',
      align: 'center',
      width: 400,
      render: text => (
        <Popover content={text} overlayStyle={{ maxWidth: '400px' }}>
          <div
            style={{
              display: '-webkit-box',
              WebkitLineClamp: '2',
              WebkitBoxOrient: 'vertical',
              overflow: 'hidden',
              textOverflow: 'ellipsis',
              textAlign: 'center'
            }}>
            {text}
          </div>
        </Popover>
      )
    }
  ]

  return <AppList {...{ remote, filters, columns }}></AppList>
}
