import { fileURLToPath, URL } from 'node:url'

import { defineConfig } from 'vite'
import react from '@vitejs/plugin-react-swc'
import mkcert from 'vite-plugin-mkcert'

// https://vitejs.dev/config/
export default defineConfig(() => {
  return {
    plugins: [react(), mkcert()],
    server: {
      open: true,
      host: 'dev.ezijing.com',
      proxy: {
        // '/api/tiangong': {
        //   target: 'https://api.singularity-ai.com',
        //   changeOrigin: true,
        //   rewrite: (path) => path.replace(/^\/api\/tiangong/, ''),
        // },
        // '/api/deepseek': {
        //   target: 'https://api.deepseek.com',
        //   changeOrigin: true,
        //   rewrite: (path) => path.replace(/^\/api\/deepseek/, ''),
        // },
        // '/api/qwen': {
        //   target: 'https://dashscope.aliyuncs.com',
        //   changeOrigin: true,
        //   rewrite: (path) => path.replace(/^\/api\/qwen/, ''),
        // },
        // '/api/qianfan': {
        //   target: 'https://aip.baidubce.com',
        //   changeOrigin: true,
        //   rewrite: (path) => path.replace(/^\/api\/qianfan/, ''),
        // },
        // '/api/wenku': {
        //   target: 'https://wenchain.baidu.com',
        //   changeOrigin: true,
        //   rewrite: (path) => path.replace(/^\/api\/wenku/, '/'),
        // },
        '/api': {
          target: 'https://zijingebook.ezijing.com',
          changeOrigin: true,
          secure: false,
        },
      },
    },
    resolve: {
      alias: {
        '@': fileURLToPath(new URL('./src', import.meta.url)),
      },
    },
    css: {
      preprocessorOptions: {
        less: {
          javascriptEnabled: true,
        },
      },
    },
  }
})
