import { DomEditor, SlateTransforms, SlateRange } from '@wangeditor/editor';

class AudioAuto {
  constructor() {
    this.title = '音频';
    this.iconSvg = `<svg width="25px" height="20px" viewBox="0 0 25 20" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <title>图标</title>
    <g id="页面-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g id="图标" transform="translate(-735.000000, -1028.000000)">
            <g id="右侧章节目录" transform="translate(551.000000, 592.000000)">
                <rect id="边框" stroke="#CCCCCC" fill="#EEEEEE" opacity="0.302679084" x="0.5" y="50.5" width="259" height="666"></rect>
                <g id="媒体资源" transform="translate(11.000000, 400.000000)" fill="#666666" fill-rule="nonzero">
                    <g id="5J音波,音频" transform="translate(173.000000, 36.000000)">
                        <path d="M19.4444754,3.93743408 L19.4444754,17.0625659 L16.6665737,17.0625659 L16.6665737,3.93743408 L19.4444754,3.93743408 L19.4444754,3.93743408 Z M8.33342634,3.93743408 L8.33342634,17.0625659 L5.55552455,17.0625659 L5.55552455,3.93743408 L8.33342634,3.93743408 Z M2.77790179,7.87486816 L2.77790179,13.1248682 L2.27373675e-13,13.1248682 L2.27373675e-13,7.87486816 L2.77790179,7.87486816 Z M25,7.87486816 L25,13.1248682 L22.2220982,13.1248682 L22.2220982,7.87486816 L25,7.87486816 Z M13.8889509,0 L13.8889509,21 L11.1110491,21 L11.1110491,0 L13.8889509,0 Z" id="形状"></path>
                    </g>
                </g>
            </g>
        </g>
    </g>
</svg>`;
    this.tag = 'button';
  }
  getValue(editor) {
    return 'hello, 音频';
  }
  isActive(editor) {
    return false; // or true
  }
  isDisabled(editor) {
    const { selection } = editor
    if (selection === null) return true
    if (SlateRange.isExpanded(selection)) return true // 选区非折叠，禁用

    const selectedElems = DomEditor.getSelectedElems(editor)

    // const hasVoidElem = selectedElems.some(elem => editor.isVoid(elem))
    // if (hasVoidElem) return true // 选中了 void 元素，禁用

    // eslint-disable-next-line array-callback-return
    const hasPreElem = selectedElems.some(elem => {
      const type = DomEditor.getNodeType(elem);
      // 代码块 引用 表格 禁用
      if (type === 'pre' || type === 'blockquote' || type === 'table' || type === 'table-row' || type === 'table-cell') return true
    })
    if (hasPreElem) return true // 选中了 pre 原则，禁用

    return false
  }
  exec(editor, value) {
    // editor.insertText(value) // value 即 this.getValue(editor) 的返回值
    if (this.isDisabled(editor)) {
      return;
    }
    editor.emit('AudioMenuClick');
  }
}

export default {
  key: 'AudioAuto', // 定义 menu key ：要保证唯一、不重复（重要）
  factory() {
    return new AudioAuto(); // 把 `YourMenuClass` 替换为你菜单的 class
  },
};

export { AudioAuto };
