import { DomEditor, SlateTransforms as Transforms, SlateRange } from '@wangeditor/editor'

// Extend menu
class ImageAutoOnline {
  constructor() {
    this.title = '在线图片'
    this.iconSvg = `<svg version="1.1" id="图层_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 viewBox="0 0 200 200" style="enable-background:new 0 0 200 200;" xml:space="preserve">
<style type="text/css">
	.st0{fill:#AF1C40;}
</style>
<path class="st0" d="M79.2,52.1c-10.4,0-18.8,8.4-18.8,18.8c0,10.4,8.4,18.8,18.8,18.8c10.4,0,18.8-8.4,18.8-18.8
	C97.9,60.5,89.5,52.1,79.2,52.1z M79.2,77.1c-3.5,0-6.2-2.8-6.2-6.2c0-3.5,2.8-6.2,6.2-6.2c3.5,0,6.2,2.8,6.2,6.2
	C85.4,74.3,82.6,77.1,79.2,77.1z"/>
<path class="st0" d="M176.6,59.3l-5.4,5.4c-0.5,0.5-1.2,0.8-1.9,0.8c0,0,0,0,0,0c-0.7,0-1.4-0.3-1.9-0.7c-0.9-0.8-1.8-1.5-2.8-2.1
	v40.6l-20.1-16.7L102,121.9l-27.3-21.6l-35.1,28.3V43.7h75.8c-0.1-0.1-0.3-0.2-0.4-0.3l-5.2-5.2c-0.5-0.5-0.8-1.3-0.8-2
	c0-0.8,0.3-1.5,0.9-2c1.1-1,2.2-2,3.3-2.9h-86v137.5h150v-110C177,58.9,176.8,59.1,176.6,59.3z M164.6,156.2h-125v-11.5l35.1-28.4
	l27.5,21.7l42.3-35.2l20.1,16.7V156.2z"/>
<g>
	<path class="st0" d="M177.5,51.6c0,0.5-0.1,1-0.4,1.5c-0.1,0.2-0.3,0.4-0.4,0.6l-5.4,5.4c-0.5,0.5-1.2,0.8-1.9,0.8c0,0,0,0,0,0
		c-0.7,0-1.4-0.3-1.9-0.7c-0.9-0.8-1.8-1.5-2.8-2.1c-3.2-2-7-3.1-10.8-3.1c-5.2,0-10.2,2-14.1,5.5c-0.4,0.3-0.9,0.5-1.5,0.5
		c-0.6,0-1.2-0.3-1.7-0.7l-5.6-5.6c-0.5-0.5-0.8-1.3-0.8-2c0-0.8,0.3-1.5,0.9-2c2.7-2.5,5.7-4.4,9-5.9c4.3-2,9-3,13.8-3
		c8.5,0,16.6,3.1,22.8,8.9c0.2,0.2,0.4,0.4,0.5,0.6C177.3,50.7,177.4,51.1,177.5,51.6z"/>
	<path class="st0" d="M153.7,74.5c-3.6,0-6.6-3-6.6-6.6s3-6.6,6.6-6.6s6.6,3,6.6,6.6S157.4,74.5,153.7,74.5z"/>
	<path class="st0" d="M192.9,36.1c0,0.8-0.3,1.5-0.8,2l-5.4,5.4c-0.5,0.5-1.2,0.8-2,0.8c-0.7,0-1.4-0.3-1.9-0.8
		c-1.8-1.7-3.7-3.2-5.8-4.6c-6.9-4.5-15-7-23.3-7c-11,0-21.3,4.2-29.3,11.7c0,0,0,0,0,0c-0.4,0.4-1,0.6-1.7,0.6
		c-0.5,0-1.1-0.1-1.8-0.6c-0.1-0.1-0.3-0.2-0.4-0.3l-5.2-5.2c-0.5-0.5-0.8-1.3-0.8-2c0-0.8,0.3-1.5,0.9-2c1.1-1,2.2-2,3.3-2.9
		c9.9-8,22.1-12.3,35-12.3c14.3,0,28,5.4,38.3,15.3C192.6,34.7,192.9,35.4,192.9,36.1z"/>
</g>
</svg>`
    this.tag = 'button'
  }
  getValue(editor) {
    return 'hello, 图片, , , 图片'
  }
  isActive(editor) {
    return false // or true
  }
  isDisabled(editor) {
    const { selection } = editor
    if (selection === null) return true
    if (SlateRange.isExpanded(selection)) return true // 选区非折叠，禁用

    const selectedElems = DomEditor.getSelectedElems(editor)

    const hasVoidElem = selectedElems.some((elem) => editor.isVoid(elem))
    if (hasVoidElem) return true // 选中了 void 元素，禁用

    // eslint-disable-next-line array-callback-return
    const hasPreElem = selectedElems.some((elem) => {
      const type = DomEditor.getNodeType(elem)
      // 代码块 引用 表格 禁用
      if (type === 'pre' || type === 'blockquote') return true
    })
    if (hasPreElem) return true // 选中了 pre 原则，禁用

    return false
  }
  getSelectedNode(editor) {
    return DomEditor.getSelectedNodeByType(editor, 'chapterImage')
  }
  exec(editor, value) {
    // editor.insertText(value) // value 即 this.getValue(editor) 的返回值

    editor.emit('ImageOnlineMenuClick')

    if (this.isDisabled(editor)) {
      return
    }

    const imageNode = this.getSelectedNode(editor)
    if (imageNode === null) return

    // 隐藏 hoverbar
    const hoverbar = DomEditor.getHoverbar(editor)
    if (hoverbar) hoverbar.hideAndClean()

    const { style = {} } = imageNode
    const props = {
      style: {
        ...style,
        width: this.value, // 修改 width
        height: '' // 清空 height
      }
    }

    Transforms.setNodes(editor, props, {
      match: (n) => DomEditor.checkNodeType(n, 'chapterImage')
    })
  }
}

class ImageWidthCustomer100 extends ImageAutoOnline {
  title = '100%' // 菜单标题
  value = '100%' // css width 的值
}

class ImageWidthCustomer50 extends ImageAutoOnline {
  title = '50%' // 菜单标题
  value = '50%' // css width 的值
}

class ImageWidthCustomer30 extends ImageAutoOnline {
  title = '30%' // 菜单标题
  value = '30%' // css width 的值
}

export default {
  key: 'ImageAutoOnline', // 定义 menu key ：要保证唯一、不重复（重要）
  factory() {
    return new ImageAutoOnline() // 把 `YourMenuClass` 替换为你菜单的 class
  }
}

const imageWidth100MenuChapterConf = {
  key: 'imageWidthChpater100',
  factory() {
    return new ImageWidthCustomer100()
  }
}

const imageWidth50MenuChapterConf = {
  key: 'imageWidthChpater50',
  factory() {
    return new ImageWidthCustomer50()
  }
}

const imageWidth30MenuChapterConf = {
  key: 'imageWidthChpater30',
  factory() {
    return new ImageWidthCustomer30()
  }
}

export { ImageAutoOnline, imageWidth100MenuChapterConf, imageWidth50MenuChapterConf, imageWidth30MenuChapterConf }
