// Extend menu
import { DomEditor, SlateTransforms, SlateRange } from '@wangeditor/editor';

class TooltipAuto {
  constructor() {
    this.title = '气泡'
    this.iconSvg = `<svg width="25px" height="21px" viewBox="0 0 25 21" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <title>图标</title>
    <g id="页面-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g id="图标" transform="translate(-481, -728)">
            <g id="右侧章节目录" transform="translate(335, 592)"></g>
            <g id="讨论" transform="translate(481, 728)" fill="#666666" fill-rule="nonzero">
                <path d="M12.5,21 C12.2729097,21 12.0578928,20.8887248 11.9148207,20.6968046 L9.81388445,17.8779585 L2.39495319,17.8779585 C1.07279784,17.8762464 0.00141566001,16.710152 0,15.2712869 L0,2.60760354 C0.000943699166,1.16837453 1.07246386,0.00171300187 2.39495319,0 L22.6050468,0 C23.9270909,0.00171177309 24.9984271,1.16761717 25,2.60636093 L25,15.2700443 C24.9985843,16.7089094 23.9272022,17.8750038 22.6050468,17.8767159 L15.1861156,17.8767159 L13.0851793,20.695562 C12.9423316,20.8879472 12.7272812,21 12.5,21 Z M2.39495319,1.64085798 C1.90453738,1.64137173 1.5070946,2.07389766 1.50662252,2.60760354 L1.50662252,15.2700443 C1.5070946,15.8037502 1.90453738,16.2362761 2.39495319,16.2367899 L10.1729847,16.2367899 C10.4000856,16.2369139 10.615044,16.3484031 10.758164,16.5402958 L12.4994291,18.8773224 L14.2406942,16.5402958 C14.3838142,16.3484031 14.5987726,16.2369139 14.8258735,16.2367899 L22.6050468,16.2367899 C23.0954626,16.2362761 23.4929054,15.8037502 23.4933775,15.2700443 L23.4933775,2.60760354 C23.4929054,2.07389766 23.0954626,1.64137173 22.6050468,1.64085798 L2.39495319,1.64085798 Z" id="形状"></path>
                <path d="M5,9.5 C5,10.3284271 5.67157288,11 6.5,11 C7.32842712,11 8,10.3284271 8,9.5 C8,8.67157288 7.32842712,8 6.5,8 C5.67157288,8 5,8.67157288 5,9.5 L5,9.5 Z" id="路径"></path>
                <path d="M11,9.5 C11,10.3284271 11.6715729,11 12.5,11 C13.3284271,11 14,10.3284271 14,9.5 C14,8.67157288 13.3284271,8 12.5,8 C11.6715729,8 11,8.67157288 11,9.5 Z" id="路径"></path>
                <path d="M17,9.5 C17,10.3284271 17.6715729,11 18.5,11 C19.3284271,11 20,10.3284271 20,9.5 C20,8.96410164 19.7141016,8.4689111 19.25,8.2009619 C18.7858984,7.9330127 18.2141016,7.9330127 17.75,8.2009619 C17.2858984,8.4689111 17,8.96410164 17,9.5 L17,9.5 Z" id="路径"></path>
            </g>
        </g>
    </g>
</svg>`;
    this.tag = 'button'
  }
  getValue(editor) {
    return 'hello, 图片, , , 图片'
  }
  isActive(editor) {
    return false;
  }
  isDisabled(editor) {
    const { selection } = editor
    if (selection === null) return true
    if (SlateRange.isExpanded(selection)) return true // 选区非折叠，禁用

    const selectedElems = DomEditor.getSelectedElems(editor)

    // const hasVoidElem = selectedElems.some(elem => editor.isVoid(elem))
    // if (hasVoidElem) return true // 选中了 void 元素，禁用

    // eslint-disable-next-line array-callback-return
    const hasPreElem = selectedElems.some(elem => {
      const type = DomEditor.getNodeType(elem);
      // 代码块 引用 表格 禁用
      if (type === 'pre' || type === 'blockquote' || type === 'table' || type === 'table-row' || type === 'table-cell') return true
    })
    if (hasPreElem) return true // 选中了 pre 原则，禁用

    return false
  }
  exec(editor, value) {
    // editor.insertText(value) // value 即 this.getValue(editor) 的返回值
    if(this.isDisabled(editor)){
      return;
    }
    editor.emit('TooltipMenuClick');
  }
}

export default {
  key: 'TooltipAuto', // 定义 menu key ：要保证唯一、不重复（重要）
  factory() {
    return new TooltipAuto() // 把 `YourMenuClass` 替换为你菜单的 class
  },
}

export {
  TooltipAuto
}