import BaseModalMenu from './common/BaseModalMenu'
import AIModal from './common/AIModal'

class AIRewrite extends BaseModalMenu {
  constructor() {
    super()

    this.title = '改写'
    this.iconSvg = `<svg width="48px" height="48px" viewBox="0 0 48 48" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <g id="页面-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g id="图标" transform="translate(-731, -218)" fill="#333333" fill-rule="nonzero">
            <g id="文稿改写" transform="translate(730.8462, 217.8462)">
                <path d="M9.34988422,18.4607791 L20.5697453,18.4607791 C21.602505,18.4607791 22.4397222,17.6342618 22.4397222,16.6147012 C22.4397222,15.5951405 21.602505,14.7686232 20.5697453,14.7686232 L9.34988422,14.7686232 C8.31712452,14.7686232 7.47990737,15.5951405 7.47990737,16.6147012 C7.47990737,17.6342618 8.31712452,18.4607791 9.34988422,18.4607791 Z M9.34988422,27.693143 L29.9216295,27.693143 C30.9543892,27.693143 31.7916063,26.8666258 31.7916063,25.8470651 C31.7916063,24.8275045 30.9543892,24.0009872 29.9216295,24.0009872 L9.34988422,24.0009872 C8.68180582,24.0009872 8.0644759,24.3528476 7.7304367,24.9240262 C7.39639749,25.4952047 7.39639749,26.1989256 7.7304367,26.7701041 C8.0644759,27.3412826 8.68180582,27.693143 9.34988422,27.693143 Z M20.5697453,33.2313768 L9.34988422,33.2313768 C8.31712452,33.2313768 7.47990737,34.057894 7.47990737,35.0774547 C7.47990737,36.0970153 8.31712452,36.9235326 9.34988422,36.9235326 L20.5697453,36.9235326 C21.602505,36.9235326 22.4397222,36.0970153 22.4397222,35.0774547 C22.4397222,34.057894 21.602505,33.2313768 20.5697453,33.2313768 L20.5697453,33.2313768 Z M47.4514124,31.6834355 L40.8394943,25.1540455 C40.4896144,24.806556 40.0138084,24.6111625 39.5175107,24.6111625 C39.0212129,24.6111625 38.5454069,24.806556 38.195527,25.1540455 L24.8576922,38.3194439 C24.5072112,38.6663408 24.3107914,39.1365536 24.3116958,39.6265065 L24.3116958,46.1519477 C24.3116958,47.1727202 25.1476886,47.9980256 26.1816758,47.9980256 L32.7935939,47.9980256 C33.2887906,47.9973508 33.7634975,47.8027942 34.1135776,47.4570359 L47.4534124,34.2916375 C48.1821959,33.5703147 48.1821959,32.4027839 47.4534124,31.6814611 L47.4514124,31.6834355 Z M32.0196035,44.3058698 L28.0536526,44.3058698 L28.0536526,40.3906051 L39.5195106,29.0693102 L43.4874615,32.9865493 L32.0196035,44.3058698 L32.0196035,44.3058698 Z" id="形状"></path>
                <path d="M18.6997684,44.3078442 L3.7399537,44.3078442 L3.7399537,3.69413026 L26.1736759,3.69413026 L26.1796758,11.0823907 C26.187371,13.1173965 27.8582693,14.7642937 29.9196295,14.7686232 L37.3995369,14.7686232 L37.3995369,19.3848052 C37.3995369,20.4043659 38.236754,21.2308831 39.2695137,21.2308831 C40.3022734,21.2308831 41.1394906,20.4043659 41.1394906,19.3848052 L41.1394906,10.3202666 C41.1394906,9.82468845 40.939493,9.35082887 40.5794975,9.00333186 L31.8536056,0.52914319 C31.5040387,0.190129754 31.0336443,0 30.5436218,0 L1.86997687,0 C1.37402817,0 0.898392224,0.194496921 0.547703531,0.540703695 C0.197014837,0.886910468 0,1.35646762 0,1.84607794 L0,46.1539221 C0,47.1746946 0.83798963,48 1.86997687,48 L18.6997684,48 C19.7325281,48 20.5697453,47.1734828 20.5697453,46.1539221 C20.5697453,45.1343614 19.7325281,44.3078442 18.6997684,44.3078442 Z M37.3855371,11.0784419 L29.9196295,11.0784419 L29.9136296,3.82246723 L37.3855371,11.0764675 L37.3855371,11.0784419 Z" id="形状"></path>
            </g>
        </g>
    </g>
</svg>`
    this.tag = 'button'
  }
  getValue(editor) {
    return <AIModal key={Date.now()} editor={editor} action="rewrite"></AIModal>
  }
}

export default {
  key: 'AIRewrite',
  factory() {
    return new AIRewrite()
  }
}
