import { Card, Input, Button, Space, Row, Col, Modal, Form } from 'antd'
import { DeleteOutlined, FacebookFilled, MessageOutlined } from '@ant-design/icons'
import './index.less'
import User from '@/assets/images/icon/user.png'
import { useState, useEffect } from 'react'
import { useLocation } from 'react-router-dom'
import { getCommentInfo, commentReply, commentDel } from '../request'
const { TextArea } = Input
const DiscussDetail = () => {
  const [showReply, setShowReply] = useState(false)
  const [delMoadal, setDelModal] = useState(false)
  const {
    state: { id, name, book_id }
  } = useLocation()
  const [form] = Form.useForm()
  const [data, setData] = useState({})
  const [loading, setLoading] = useState(false)
  const [commentId, setcommentId] = useState(0)
  // 获取列表
  const init = async () => {
    setLoading(true)
    const data = await getCommentInfo({ id, book_id })
    console.log(data)
    setData(data)
    setLoading(false)
  }
  useEffect(() => {
    init()
  }, [])
  useEffect(() => {
    if (!showReply) {
      form.setFieldsValue({ content: '' })
      form.resetFields()
    }
  }, [showReply])
  // 显示回复弹框
  const showReplyFn = id => {
    setcommentId(id)
    setShowReply(true)
  }
  // 点击确认回复
  const handleReply = async obj => {
    const bool = await commentReply({ ...obj, id: commentId, book_id })
    if (!bool) return
    setShowReply(false)
    init()
  }
  const handleDel = async () => {
    const bool = await commentDel({ id: commentId, book_id })
    if (!bool) return
    setDelModal(false)
    init()
  }
  return (
    <div className="DiscussDetail">
      <Modal
        open={showReply}
        onCancel={() => {
          setShowReply(false)
        }}
        maskClosable={false}
        footer={null}
        centered
        closeIcon={null}
        keyboard={false}>
        <br />
        <Form form={form} onFinish={handleReply}>
          <Form.Item label="内容" name="content" rules={[{ required: true, message: '请输入内容' }]}>
            <TextArea
              placeholder="请输入内容"
              autoSize={{
                minRows: 3,
                maxRows: 5
              }}></TextArea>
          </Form.Item>
          <Form.Item>
            <Row gutter={20} justify={'center'}>
              <Col>
                <Button onClick={() => setShowReply(false)}>取消</Button>
              </Col>
              <Col>
                <Button type="primary" htmlType="submit">
                  确认
                </Button>
              </Col>
            </Row>
          </Form.Item>
        </Form>
      </Modal>
      <Modal
        mask={false}
        centered
        open={delMoadal}
        onOk={handleDel}
        onCancel={() => setDelModal(false)}
        footer={(_, { OkBtn, CancelBtn }) => {
          return (
            <Row justify={'center'} className="delModal">
              <Space>
                <CancelBtn />
                <OkBtn />
              </Space>
            </Row>
          )
        }}
        okText="确认">
        <p style={{ textAlign: 'center', padding: '50px 0 30px', fontSize: 16 }}>评论将永久删除，是否继续?</p>
      </Modal>
      <Card className="card" title={`书名：《${name}》`} loading={loading}>
        <div className="discussBox">
          <Row className="discussItem" gutter={10}>
            <Col className="img">
              <img
                src={data.person_pic || User}
                width={28}
                height={28}
                style={{ borderRadius: '50%', objectFit: 'cover' }}
              />
            </Col>
            <Col className="discuss" flex={1}>
              <div className="name">{data.person_name}</div>
              {/* <div className='content'>{data?.content && data.content[0].content}</div> */}
              <div className="content">
                {data?.content &&
                  data.content.map((item, index) => {
                    const type = item.types
                    const value = item.content

                    if (type === 'audio') {
                      return (
                        <div key={index}>
                          <span>
                            <audio controls>
                              <source src={value} type="audio/mp3" />
                              Your browser does not support the audio element.
                            </audio>
                          </span>
                        </div>
                      )
                    } else if (type === 'text') {
                      return <span key={index}>{value}</span>
                    } else if (type === 'image') {
                      return <img height={100} src={value}></img>
                    }
                  })}
              </div>
              <Space>
                <Button type="text" className="reply" onClick={() => showReplyFn(data.id)} icon={<MessageOutlined />}>
                  回复
                </Button>
                <Button
                  type="text"
                  className="del"
                  icon={<DeleteOutlined />}
                  onClick={() => {
                    setDelModal(true)
                    setcommentId(data.id)
                  }}>
                  删除
                </Button>
              </Space>
            </Col>
          </Row>
          {data.child &&
            data.child.map(item => (
              <Row className="discussItem reply" key={item.id} gutter={10}>
                <Col span={1}></Col>
                <Col className="img">
                  <img
                    src={item.person_pic || User}
                    width={28}
                    height={28}
                    style={{ borderRadius: '50%', objectFit: 'cover' }}
                  />
                </Col>
                <Col className="discuss" flex={1}>
                  <div className="name">{item.person_name}</div>
                  <div className="content">
                    {item.content &&
                      item.content.map((item, index) => (
                        <div key={index}>
                          {item.types == 'text' && <span>{item.content}</span>}
                          {item.types == 'image' && <img src={item.content}></img>}
                          {item.types == 'audio' && <audio controls src={item.content} />}
                        </div>
                      ))}
                  </div>
                  <Space>
                    <Button
                      type="text"
                      className="reply"
                      onClick={() => showReplyFn(item.id)}
                      icon={<MessageOutlined />}>
                      回复
                    </Button>
                    <Button
                      type="text"
                      className="del"
                      icon={<DeleteOutlined />}
                      onClick={() => {
                        setDelModal(true)
                        setcommentId(item.id)
                      }}>
                      删除
                    </Button>
                  </Space>
                </Col>
              </Row>
            ))}
        </div>
        {/*  <div className="discussCreate">
          <Row gutter={10}>
            <Col><div className="img"><img src={User} width={28} height={28} /></div></Col>
            <Col><Input autoComplete="off" placeholder="发布你的评论" style={{width:754}}></Input ></Col>
            <Col>
              <Space>
                <Button>取消</Button>
                <Button type="primary">回复</Button>
              </Space>
            </Col>
          </Row>
        </div> */}
      </Card>
    </div>
  )
}

export default DiscussDetail
