import axios from '@/utils/axios'

// 获取书籍详情
export function getBook(data) {
  return axios.post('/api/book/teacher/getInfoById', data)
}

// 获取章节列表
export function getChapterList(data) {
  return axios.post('/api/book/teacher/chapter/getAllList', data)
}

// 获取章节详情
export function getChapter(data) {
  return axios.post('/api/book/teacher/chapter/getInfoById', data)
}

// 添加章节
export function addChapter(data) {
  return axios.post('/api/book/teacher/chapter/add', data)
}

// 修改章节
export function updateChapter(data) {
  return axios.post('/api/book/teacher/chapter/edit', data)
}

// 删除章节
export function delChapter(data) {
  return axios.post('/api/book/teacher/chapter/del', data)
}

// 章节排序
export function sortChapter(data) {
  return axios.post('/api/book/teacher/chapter/dragOrder', data)
}

// 获取章节编辑者信息
export function getChapterEditors(data) {
  return axios.post('/api/book/teacher/chapter/getEditors', data)
}

// 保存章节编辑者
export function updateChapterEditors(data) {
  return axios.post('/api/book/teacher/chapter/saveEditors', data)
}

// 知识图谱列表
export function getTagList(params) {
  return axios.get('/api/resource/v1/course/course/tag-list', { params })
}

// 知识图谱关联书籍章节
export function bindTag(data) {
  return axios.post('/api/resource/v1/course/course/tag-add-book', data)
}
