import React, { useEffect, useState } from 'react';
import {
  Table,
  Input,
  Button,
  Row,
  Col,
  Space,
  DatePicker,
  Pagination,
  Drawer,
  Form,
  Select,
} from 'antd';
const { RangePicker } = DatePicker;
import { useLocation } from 'react-router-dom';
import PaginationCom from '@/common/Pagination/index.jsx';
import { getCouponList } from '../list/request';
const CouponRecord = (props) => {
  const { id } = props;
  const [data, setData] = useState([]);
  const [page_size, setpage_size] = useState(10);
  const [page, setPage] = useState(1);
  const [total, setTotal] = useState(0);
  const [loading, setLoading] = useState(true);
  const [isEdit, setIsEdit] = useState(false);
  const [form] = Form.useForm();
  const init = async (obj = {}) => {
    setLoading(true);
    const { total, list } = await getCouponList({ id });
    setTotal(total);
    setData(list);
    setLoading(false);
  };
  const columns = [
    {
      title: '优惠券名称',
      key: 'coupon_name',
      dataIndex: 'coupon_name',
      align: 'center',
    },
    {
      title: '领取时间',
      key: 'create_time',
      dataIndex: 'create_time',
      align: 'center',
    },
    {
      title: '有效期',
      key: 'end_time',
      dataIndex: 'end_time',
      align: 'center',
    },
    {
      title: '使用状态',
      key: 'use_status_name',
      dataIndex: 'use_status_name',
      align: 'center',
    },
  ];
  return (
    <div>
      <Table
        scroll={{
          y: 600,
          x: true,
        }}
        columns={columns}
        rowKey={(record) => record.ID}
        dataSource={data}
        loading={loading}
        pagination={false}
      ></Table>
      <br />
      <PaginationCom
        total={total}
        page_size={page_size}
        setpage_size={setpage_size}
        page={page}
        setPage={setPage}
        init={init}
      />
    </div>
  );
};

export default CouponRecord;
