import axios from '@/utils/request.js';
import qs from 'qs';
import { message } from 'antd';
import { get } from 'lodash-es';
// 获取列表
const getList = async (obj) => {
  try {
    const res = await axios.post('/system/app/help/getList', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return error;
  }
};
// 添加帮助
const addHelp = async (obj) => {
  try {
    const res = await axios.post('/system/app/help/add', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      message.success(msg);
      return true;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return error;
  }
};
// 获取帮助详情
const HelpInfo = async (obj) => {
  try {
    const res = await axios.post('/system/app/help/getInfoById', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return error;
  }
};
// 修改
const editHelp = async (obj) => {
  try {
    const res = await axios.post('/system/app/help/edit', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      message.success(msg);
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return error;
  }
};

// 修改
const editPreview = async (obj) => {
  try {
    const res = await axios.post('/system/app/help/edit', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return error;
  }
};
// 删除
const delHelp = async (obj) => {
  try {
    const res = await axios.post('/system/app/help/del', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      message.success(msg);
      return true;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return error;
  }
};

export { getList, addHelp, HelpInfo, editHelp, delHelp, editPreview };
