import axios from '@/utils/request.js';
import qs from 'qs';
import { message } from 'antd';
import { get } from 'lodash-es';
// 敏感词
// 获取列表
const getList = async (obj) => {
  try {
    const res = await axios.post('/system/sensitive/words/getList', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return error;
  }
};
// 添加
const addWords = async (obj) => {
  try {
    const res = await axios.post('/system/sensitive/words/add', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      message.success(msg);
      return true;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return error;
  }
};
// 修改
const editWords = async (obj) => {
  try {
    const res = await axios.post('/system/sensitive/words/edit', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      message.success(msg);
      return true;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return error;
  }
};
// 删除
const delWords = async (obj) => {
  try {
    const res = await axios.post('/system/sensitive/words/del', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      // message.success(msg)
      return true;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return error;
  }
};
// 详情
const infoWords = async (obj) => {
  try {
    const res = await axios.post('/system/sensitive/words/getInfoById', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      message.success(msg);
      return true;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return error;
  }
};
// 导入
const importWords = async (obj) => {
  try {
    const res = await axios.post('/system/sensitive/words/import', obj, {
      headers: {
        'Content-Type': '	multipart/form-data',
      },
    });
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return { msg, err: data.err };
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return error;
  }
};
export { getList, addWords, importWords, editWords, delWords, infoWords };
