import { createSlice } from '@reduxjs/toolkit';

const initialState = {
  practiceRandom: '', // 存储练习随机数
  practiceTitle: '', // 存储练习随机数
  practiceTheme: '', // 存储练习随机数
  chapterTitleRandom: '', // 章头
  chapterSectionRandom: '', // 节头
  autosaveTime: 0, // 自动保存设置
  editorAi: {}, // ai 信息设置
};

export const editor = createSlice({
  // 命名空间
  name: 'editor',
  // 初始化状态值
  initialState,
  // 定义 reducers 并生成关联的操作
  reducers: {
    // 设置用户个人信息
    setResetInit(state, { payload }) {
      state.practiceRandom = '';
      state.chapterTitleRandom = '';
      state.chapterSectionRandom = '';
    },
    // 设置交互练习弹窗
    setPracticeRandom(state, { payload }) {
      state.practiceRandom = payload.practiceNum;
      state.practiceTitle = payload.practiceTitle;
      state.practiceTheme = payload.practiceTheme;
    },
    // 设置章头
    setChapterTitleRandom(state, { payload }) {
      state.chapterTitleRandom = payload;
    },
    // 设置节头
    setChapterSectionRandom(state, { payload }) {
      state.chapterSectionRandom = payload;
    },
    // 设置节头
    setAutosaveTime(state, { payload }) {
      state.autosaveTime = payload;
    },
    // 设置节头
    setEditorAi(state, { payload }) {
      state.editorAi = payload;
    }
  },
});

export const { setResetInit, setPracticeRandom, setChapterTitleRandom, setChapterSectionRandom, setAutosaveTime, setEditorAi } = editor.actions;

export default editor.reducer;
