import React, { useState, useEffect, useRef } from 'react';
import { Pagination, Space, InputNumber, Button, Select } from 'antd';
import { LeftOutlined, RightOutlined } from '@ant-design/icons';
import './index.less';
const PaginationCom = (props) => {
  const {
    total,
    page = 1,
    page_size = 10,
    setpage_size = () => {},
    filterObj = {},
    setPage = () => {},
    init = () => {},
  } = props;
  const isFirstRender = useRef(true); // 使用 useRef 创建一个标志位
  const pageItemRender = (page, type, originalElement) => {
    if (type === 'prev') {
      return (
        <Button
          disabled={page === 1}
          type='default'
          icon={<LeftOutlined style={{ width: 10 }} />}
        ></Button>
      );
    }
    if (type === 'next') {
      return (
        <Button
          disabled={total / page_size >= page}
          type='default'
          icon={<RightOutlined style={{ width: 10 }} />}
        ></Button>
      );
    }

    return originalElement;
  };
  const [jumpSize, setJumpSize] = useState(1);
  const [maxSize, setMaxSize] = useState(1);
  useEffect(() => {
    if (total) {
      setMaxSize(Math.ceil(total / page_size));
    }
    if (page) {
      setJumpSize(page);
    }
  }, [total, page]);
  useEffect(() => {
    // console.log('page', page, filterObj)
    // 在第一次渲染时不执行 init 函数
    // if (!isFirstRender.current) {
    let obj = { ...filterObj };
    for (const key in obj) {
      if (!obj[key]) {
        delete obj[key];
      }
    }
    init(obj);
    // } else {
    // isFirstRender.current = false;
    // }
  }, [page, page_size]);
  return (
    <div
      className='pagination'
      style={{
        display: 'flex',
        justifyContent: 'space-between',
        alignItems: 'center',
        paddingBottom: 10,
      }}
    >
      <Space>
        <span>共{total}条数据</span>
        <Select
          defaultValue={page_size}
          options={[
            {
              label: '10条/页',
              value: 10,
            },
            {
              label: '20条/页',
              value: 20,
            },
            {
              label: '30条/页',
              value: 30,
            },
            {
              label: '40条/页',
              value: 40,
            },
          ]}
          onChange={(val) => {
            setPage(1);
            setpage_size(val);
          }}
        />
      </Space>

      <div style={{ display: 'flex', justifyContent: 'flex-end', alignItems: 'center' }}>
        <Space>
          <Pagination
            current={page}
            total={total}
            showSizeChanger={false} // 隐藏每页条数选择框
            pageSize={page_size}
            showQuickJumper={false}
            onChange={(val) => {
              setPage(val);
              if (document.querySelector('.ant-table-body')) {
                document.querySelector('.ant-table-body').scrollTo({
                  top: 0,
                  behavior: 'smooth',
                });
              }
            }}
            itemRender={pageItemRender}
          ></Pagination>
          <Space>
            <span>前往</span>
            <InputNumber
              className='aa'
              autoComplete='off'
              value={jumpSize}
              controls={false}
              onPressEnter={(ev) => {
                let val = ev.target.value;
                let reg = /^\d+$/;
                if (!reg.test(val)) {
                  return;
                }
                if (!val || val < 1) {
                  setPage(1);
                  setJumpSize(1);
                  return;
                }
                if (val >= maxSize) {
                  setPage(maxSize);
                  setJumpSize(maxSize);
                  return;
                }
                setPage(val);
                setJumpSize(val);
              }}
              style={{ width: 50 }}
            />
            <span>页</span>
          </Space>
        </Space>
      </div>
    </div>
  );
};

export default PaginationCom;
